/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.textures.Textures;
import mezz.jei.plugins.jei.info.IngredientInfoRecipe;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class IngredientInfoRecipeCategory
implements IRecipeCategory<IngredientInfoRecipe> {
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    private static final int lineSpacing = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final String localizedName;

    public IngredientInfoRecipeCategory(IGuiHelper guiHelper, Textures textures) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        this.icon = textures.getInfoIcon();
        this.slotBackground = guiHelper.getSlotDrawable();
        this.localizedName = Translator.translateToLocal("gui.jei.category.itemInformation");
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaRecipeCategoryUid.INFORMATION;
    }

    @Override
    public Class<? extends IngredientInfoRecipe> getRecipeClass() {
        return IngredientInfoRecipe.class;
    }

    @Override
    public String getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void setIngredients(IngredientInfoRecipe recipe, IIngredients ingredients) {
        this.setIngredientsTyped(recipe, ingredients);
    }

    private <T> void setIngredientsTyped(IngredientInfoRecipe<T> recipe, IIngredients ingredients) {
        IIngredientType<T> ingredientType = recipe.getIngredientType();
        List<List<T>> recipeIngredients = Collections.singletonList(recipe.getIngredients());
        ingredients.setInputLists(ingredientType, recipeIngredients);
        ingredients.setOutputLists(ingredientType, recipeIngredients);
    }

    @Override
    public void draw(IngredientInfoRecipe recipe, double mouseX, double mouseY) {
        this.drawTyped(recipe);
    }

    private <T> void drawTyped(IngredientInfoRecipe<T> recipe) {
        boolean xPos = false;
        int yPos = this.slotBackground.getHeight() + 4;
        Minecraft minecraft = Minecraft.func_71410_x();
        for (String descriptionLine : recipe.getDescription()) {
            minecraft.field_71466_p.func_211126_b(descriptionLine, (float)xPos, (float)yPos, -16777216);
            yPos += minecraft.field_71466_p.field_78288_b + 2;
        }
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, IngredientInfoRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int xPos = 71;
        guiItemStacks.init(0, true, xPos, 0);
        guiItemStacks.setBackground(0, this.slotBackground);
        guiItemStacks.set(ingredients);
        IGuiFluidStackGroup guiFluidStackGroup = recipeLayout.getFluidStacks();
        guiFluidStackGroup.init(0, true, xPos + 1, 1);
        guiFluidStackGroup.set(ingredients);
    }
}

