/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.debug;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugGhostIngredientHandler<T extends GuiContainer>
implements IGhostIngredientHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(T gui, I ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        targets.add(new DebugInfoTarget("Got an Ingredient", new Rectangle2d(0, 0, 20, 20)));
        if (doStart) {
            IIngredientHelper<I> ingredientHelper = Internal.getIngredientManager().getIngredientHelper(ingredient);
            LOGGER.info("Ghost Ingredient Handling Starting with {}", (Object)ingredientHelper.getErrorInfo(ingredient));
            targets.add(new DebugInfoTarget("Got an Ingredient", new Rectangle2d(20, 20, 20, 20)));
        }
        if (ingredient instanceof ItemStack) {
            boolean even = true;
            for (Slot slot : ((GuiContainer)gui).field_147002_h.field_75151_b) {
                if (even) {
                    Rectangle2d area = new Rectangle2d(gui.getGuiLeft() + slot.field_75223_e, gui.getGuiTop() + slot.field_75221_f, 16, 16);
                    targets.add(new DebugInfoTarget("Got an Ingredient in Gui", area));
                }
                even = !even;
            }
        }
        return targets;
    }

    @Override
    public void onComplete() {
        LOGGER.info("Ghost Ingredient Handling Complete");
    }

    private static class DebugInfoTarget<I>
    implements IGhostIngredientHandler.Target<I> {
        private final String message;
        private final Rectangle2d rectangle;

        public DebugInfoTarget(String message, Rectangle2d rectangle) {
            this.message = message;
            this.rectangle = rectangle;
        }

        @Override
        public Rectangle2d getArea() {
            return this.rectangle;
        }

        @Override
        public void accept(I ingredient) {
            IIngredientHelper<I> ingredientHelper = Internal.getIngredientManager().getIngredientHelper(ingredient);
            LOGGER.info("{}: {}", (Object)this.message, (Object)ingredientHelper.getErrorInfo(ingredient));
        }
    }
}

