/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class Ingredients
implements IIngredients {
    private final Map<IIngredientType, List<List>> inputs = new IdentityHashMap<IIngredientType, List<List>>();
    private final Map<IIngredientType, List<List>> outputs = new IdentityHashMap<IIngredientType, List<List>>();

    @Override
    public <T> void setInput(IIngredientType<T> ingredientType, T input) {
        this.setInputs(ingredientType, Collections.singletonList(input));
    }

    @Override
    public <T> void setInputLists(IIngredientType<T> ingredientType, List<List<T>> inputs) {
        ArrayList<List<T>> expandedInputs = new ArrayList<List<T>>(inputs);
        this.inputs.put(ingredientType, expandedInputs);
    }

    @Override
    public void setInputIngredients(List<Ingredient> inputs) {
        ArrayList inputLists = new ArrayList();
        for (Ingredient input : inputs) {
            ItemStack[] stacks = input.func_193365_a();
            List<ItemStack> expandedInput = Arrays.asList(stacks);
            inputLists.add(expandedInput);
        }
        this.setInputLists(VanillaTypes.ITEM, inputLists);
    }

    @Override
    public <T> void setInputs(IIngredientType<T> ingredientType, List<T> inputs) {
        ArrayList<List<T>> expandedInputs = new ArrayList<List<T>>();
        for (T input : inputs) {
            List<T> expandedInput = Collections.singletonList(input);
            expandedInputs.add(expandedInput);
        }
        this.inputs.put(ingredientType, expandedInputs);
    }

    @Override
    public <T> void setOutput(IIngredientType<T> ingredientType, T output) {
        this.setOutputs(ingredientType, Collections.singletonList(output));
    }

    @Override
    public <T> void setOutputs(IIngredientType<T> ingredientType, List<T> outputs) {
        ArrayList<List<T>> expandedOutputs = new ArrayList<List<T>>();
        for (T output : outputs) {
            List<T> expandedOutput = Collections.singletonList(output);
            expandedOutputs.add(expandedOutput);
        }
        this.outputs.put(ingredientType, expandedOutputs);
    }

    @Override
    public <T> void setOutputLists(IIngredientType<T> ingredientType, List<List<T>> outputs) {
        ArrayList<List<T>> expandedOutputs = new ArrayList<List<T>>(outputs);
        this.outputs.put(ingredientType, expandedOutputs);
    }

    @Override
    public <T> List<List<T>> getInputs(IIngredientType<T> ingredientType) {
        List<List<T>> inputs = this.inputs.get(ingredientType);
        if (inputs == null) {
            return Collections.emptyList();
        }
        return inputs;
    }

    @Override
    public <T> List<List<T>> getOutputs(IIngredientType<T> ingredientType) {
        List<List<T>> outputs = this.outputs.get(ingredientType);
        if (outputs == null) {
            return Collections.emptyList();
        }
        return outputs;
    }

    public Map<IIngredientType, List> getInputIngredients() {
        IdentityHashMap<IIngredientType, List> inputIngredients = new IdentityHashMap<IIngredientType, List>();
        for (Map.Entry<IIngredientType, List<List>> entry : this.inputs.entrySet()) {
            ArrayList flatIngredients = new ArrayList();
            for (List ingredients : entry.getValue()) {
                flatIngredients.addAll(ingredients);
            }
            inputIngredients.put(entry.getKey(), flatIngredients);
        }
        return inputIngredients;
    }

    public Map<IIngredientType, List> getOutputIngredients() {
        IdentityHashMap<IIngredientType, List> outputIngredients = new IdentityHashMap<IIngredientType, List>();
        for (Map.Entry<IIngredientType, List<List>> entry : this.outputs.entrySet()) {
            ArrayList flatIngredients = new ArrayList();
            for (List ingredients : entry.getValue()) {
                flatIngredients.addAll(ingredients);
            }
            outputIngredients.put(entry.getKey(), flatIngredients);
        }
        return outputIngredients;
    }
}

