/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.events.OverlayToggleEvent;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.LeftAreaDispatcher;
import mezz.jei.input.MouseUtil;
import mezz.jei.util.LimitedLogger;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LimitedLogger missingBackgroundLogger = new LimitedLogger(LOGGER, Duration.ofHours(1L));
    private final IngredientListOverlay ingredientListOverlay;
    private final GuiScreenHelper guiScreenHelper;
    private final LeftAreaDispatcher leftAreaDispatcher;
    private boolean drawnOnBackground = false;

    public GuiEventHandler(GuiScreenHelper guiScreenHelper, LeftAreaDispatcher leftAreaDispatcher, IngredientListOverlay ingredientListOverlay) {
        this.guiScreenHelper = guiScreenHelper;
        this.leftAreaDispatcher = leftAreaDispatcher;
        this.ingredientListOverlay = ingredientListOverlay;
    }

    @SubscribeEvent
    public void onOverlayToggle(OverlayToggleEvent event) {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        this.ingredientListOverlay.updateScreen(currentScreen, true);
        this.leftAreaDispatcher.updateScreen(currentScreen, false);
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        this.ingredientListOverlay.updateScreen(gui, false);
        this.leftAreaDispatcher.updateScreen(gui, false);
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        GuiScreen gui = event.getGui();
        this.ingredientListOverlay.updateScreen(gui, false);
        this.leftAreaDispatcher.updateScreen(gui, false);
    }

    @SubscribeEvent
    public void onDrawBackgroundEventPost(GuiScreenEvent.BackgroundDrawnEvent event) {
        GuiScreen gui = event.getGui();
        boolean exclusionAreasChanged = this.guiScreenHelper.updateGuiExclusionAreas();
        this.ingredientListOverlay.updateScreen(gui, exclusionAreasChanged);
        this.leftAreaDispatcher.updateScreen(gui, exclusionAreasChanged);
        this.drawnOnBackground = true;
        double mouseX = MouseUtil.getX();
        double mouseY = MouseUtil.getY();
        this.ingredientListOverlay.drawScreen(gui.field_146297_k, (int)mouseX, (int)mouseY, gui.field_146297_k.func_184121_ak());
        this.leftAreaDispatcher.drawScreen(gui.field_146297_k, (int)mouseX, (int)mouseY, gui.field_146297_k.func_184121_ak());
    }

    @SubscribeEvent
    public void onDrawForegroundEvent(GuiContainerEvent.DrawForeground event) {
        GuiContainer gui = event.getGuiContainer();
        this.ingredientListOverlay.drawOnForeground(gui, event.getMouseX(), event.getMouseY());
        this.leftAreaDispatcher.drawOnForeground(gui, event.getMouseX(), event.getMouseY());
    }

    @SubscribeEvent
    public void onDrawScreenEventPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiContainer guiContainer;
        IGuiClickableArea guiClickableArea;
        GuiScreen gui = event.getGui();
        this.ingredientListOverlay.updateScreen(gui, false);
        this.leftAreaDispatcher.updateScreen(gui, false);
        if (!this.drawnOnBackground) {
            if (gui instanceof GuiContainer) {
                String guiName = gui.getClass().getName();
                missingBackgroundLogger.log(Level.WARN, guiName, "GUI did not draw the dark background layer behind itself, this may result in display issues: {}", guiName);
            }
            this.ingredientListOverlay.drawScreen(gui.field_146297_k, event.getMouseX(), event.getMouseY(), gui.field_146297_k.func_184121_ak());
            this.leftAreaDispatcher.drawScreen(gui.field_146297_k, event.getMouseX(), event.getMouseY(), gui.field_146297_k.func_184121_ak());
        }
        this.drawnOnBackground = false;
        if (gui instanceof GuiContainer && (guiClickableArea = this.guiScreenHelper.getGuiClickableArea(guiContainer = (GuiContainer)gui, event.getMouseX() - guiContainer.getGuiLeft(), event.getMouseY() - guiContainer.getGuiTop())) != null) {
            List<String> tooltipStrings = guiClickableArea.getTooltipStrings();
            if (tooltipStrings.isEmpty()) {
                tooltipStrings = Collections.singletonList(Translator.translateToLocal("jei.tooltip.show.recipes"));
            }
            TooltipRenderer.drawHoveringText(tooltipStrings, event.getMouseX(), event.getMouseY(), 150);
        }
        this.ingredientListOverlay.drawTooltips(gui.field_146297_k, event.getMouseX(), event.getMouseY());
        this.leftAreaDispatcher.drawTooltips(gui.field_146297_k, event.getMouseX(), event.getMouseY());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.ingredientListOverlay.handleTick();
    }

    @SubscribeEvent
    public void onPotionShiftEvent(GuiScreenEvent.PotionShiftEvent event) {
        if (this.ingredientListOverlay.isListDisplayed()) {
            event.setCanceled(true);
        }
    }
}

