/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients.enchant;

import com.google.common.base.MoreObjects;
import java.awt.Color;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.plugins.vanilla.ingredients.enchant.EnchantedBookCache;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class EnchantDataHelper
implements IIngredientHelper<EnchantmentData> {
    private final EnchantedBookCache cache;
    private final IIngredientHelper<ItemStack> itemStackHelper;

    public EnchantDataHelper(EnchantedBookCache cache, IIngredientHelper<ItemStack> itemStackHelper) {
        this.cache = cache;
        this.itemStackHelper = itemStackHelper;
    }

    @Override
    @Nullable
    public EnchantmentData getMatch(Iterable<EnchantmentData> ingredients, EnchantmentData toMatch) {
        for (EnchantmentData enchantData : ingredients) {
            if (enchantData.field_76302_b.getRegistryName() != toMatch.field_76302_b.getRegistryName() || enchantData.field_76303_c != toMatch.field_76303_c) continue;
            return enchantData;
        }
        return null;
    }

    @Override
    public IFocus<?> translateFocus(IFocus<EnchantmentData> focus, IIngredientHelper.IFocusFactory focusFactory) {
        EnchantmentData enchantData = focus.getValue();
        ItemStack itemStack = this.cache.getEnchantedBook(enchantData);
        return focusFactory.createFocus(focus.getMode(), itemStack);
    }

    @Override
    public String getDisplayName(EnchantmentData ingredient) {
        return ingredient.field_76302_b.func_77316_c(ingredient.field_76303_c);
    }

    @Override
    public String getUniqueId(EnchantmentData ingredient) {
        return "enchantment:" + ingredient.field_76302_b.func_77320_a() + ".lvl" + ingredient.field_76303_c;
    }

    @Override
    public String getWildcardId(EnchantmentData ingredient) {
        return this.getUniqueId(ingredient);
    }

    @Override
    public String getModId(EnchantmentData ingredient) {
        ResourceLocation registryName = ingredient.field_76302_b.getRegistryName();
        if (registryName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("enchantment.getRegistryName() returned null for: " + stackInfo);
        }
        return registryName.func_110624_b();
    }

    @Override
    public String getDisplayModId(EnchantmentData ingredient) {
        ItemStack enchantedBook = this.cache.getEnchantedBook(ingredient);
        return this.itemStackHelper.getDisplayModId(enchantedBook);
    }

    @Override
    public Iterable<Color> getColors(EnchantmentData ingredient) {
        ItemStack enchantedBook = this.cache.getEnchantedBook(ingredient);
        return this.itemStackHelper.getColors(enchantedBook);
    }

    @Override
    public String getResourceId(EnchantmentData ingredient) {
        ResourceLocation registryName = ingredient.field_76302_b.getRegistryName();
        if (registryName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("enchantment.getRegistryName() returned null for: " + stackInfo);
        }
        return registryName.func_110623_a();
    }

    @Override
    public ItemStack getCheatItemStack(EnchantmentData ingredient) {
        return this.cache.getEnchantedBook(ingredient);
    }

    @Override
    public EnchantmentData copyIngredient(EnchantmentData ingredient) {
        return new EnchantmentData(ingredient.field_76302_b, ingredient.field_76303_c);
    }

    @Override
    public boolean isIngredientOnServer(EnchantmentData ingredient) {
        ItemStack enchantedBook = this.cache.getEnchantedBook(ingredient);
        return this.itemStackHelper.isIngredientOnServer(enchantedBook);
    }

    @Override
    public String getErrorInfo(@Nullable EnchantmentData ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(EnchantmentData.class);
        toStringHelper.add("Enchantment", (Object)ingredient.field_76302_b.func_77320_a());
        toStringHelper.add("Level", ingredient.field_76303_c);
        return toStringHelper.toString();
    }
}

