/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapelessOreRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipesWrapper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class CraftingRecipeChecker {
    private CraftingRecipeChecker() {
    }

    public static List<IRecipe> getValidRecipes(final IJeiHelpers jeiHelpers) {
        CraftingRecipeValidator<ShapedOreRecipe> shapedOreRecipeValidator = new CraftingRecipeValidator<ShapedOreRecipe>(){

            @Override
            protected IRecipeWrapper getRecipeWrapper(ShapedOreRecipe recipe) {
                return new ShapedOreRecipeWrapper(jeiHelpers, recipe);
            }

            @Override
            protected int getInputCount(ShapedOreRecipe recipe) {
                return 1.getInputCount(recipe.getInput());
            }
        };
        CraftingRecipeValidator<ShapedRecipes> shapedRecipesValidator = new CraftingRecipeValidator<ShapedRecipes>(){

            @Override
            protected IRecipeWrapper getRecipeWrapper(ShapedRecipes recipe) {
                return new ShapedRecipesWrapper(recipe);
            }

            @Override
            protected int getInputCount(ShapedRecipes recipe) {
                return 2.getInputCount(recipe.field_77574_d);
            }
        };
        CraftingRecipeValidator<ShapelessOreRecipe> shapelessOreRecipeValidator = new CraftingRecipeValidator<ShapelessOreRecipe>(){

            @Override
            protected IRecipeWrapper getRecipeWrapper(ShapelessOreRecipe recipe) {
                return new ShapelessOreRecipeWrapper(jeiHelpers, recipe);
            }

            @Override
            protected int getInputCount(ShapelessOreRecipe recipe) {
                return 3.getInputCount(recipe.getInput());
            }
        };
        CraftingRecipeValidator<ShapelessRecipes> shapelessRecipesValidator = new CraftingRecipeValidator<ShapelessRecipes>(){

            @Override
            protected IRecipeWrapper getRecipeWrapper(ShapelessRecipes recipe) {
                return new ShapelessRecipesWrapper(recipe);
            }

            @Override
            protected int getInputCount(ShapelessRecipes recipe) {
                return 4.getInputCount(recipe.field_77579_b);
            }
        };
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        ArrayList<IRecipe> validRecipes = new ArrayList<IRecipe>(recipes.size());
        for (IRecipe recipe : recipes) {
            if (recipe instanceof ShapedOreRecipe) {
                if (!shapedOreRecipeValidator.isRecipeValid((ShapedOreRecipe)recipe)) continue;
                validRecipes.add(recipe);
                continue;
            }
            if (recipe instanceof ShapedRecipes) {
                if (!shapedRecipesValidator.isRecipeValid((ShapedRecipes)recipe)) continue;
                validRecipes.add(recipe);
                continue;
            }
            if (recipe instanceof ShapelessOreRecipe) {
                if (!shapelessOreRecipeValidator.isRecipeValid((ShapelessOreRecipe)recipe)) continue;
                validRecipes.add(recipe);
                continue;
            }
            if (recipe instanceof ShapelessRecipes) {
                if (!shapelessRecipesValidator.isRecipeValid((ShapelessRecipes)recipe)) continue;
                validRecipes.add(recipe);
                continue;
            }
            validRecipes.add(recipe);
        }
        return validRecipes;
    }

    private static abstract class CraftingRecipeValidator<T extends IRecipe> {
        private static final int INVALID_COUNT = -1;

        private CraftingRecipeValidator() {
        }

        public boolean isRecipeValid(T recipe) {
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput == null || recipeOutput.func_190926_b()) {
                String recipeInfo = this.getInfo(recipe);
                Log.error("Recipe has no output. {}", recipeInfo);
                return false;
            }
            int inputCount = this.getInputCount(recipe);
            if (inputCount == -1) {
                return false;
            }
            if (inputCount > 9) {
                String recipeInfo = this.getInfo(recipe);
                Log.error("Recipe has too many inputs. {}", recipeInfo);
                return false;
            }
            if (inputCount == 0) {
                String recipeInfo = this.getInfo(recipe);
                Log.error("Recipe has no inputs. {}", recipeInfo);
                return false;
            }
            return true;
        }

        private String getInfo(T recipe) {
            IRecipeWrapper recipeWrapper = this.getRecipeWrapper(recipe);
            return ErrorUtil.getInfoFromRecipe(recipe, recipeWrapper);
        }

        protected abstract IRecipeWrapper getRecipeWrapper(T var1);

        protected abstract int getInputCount(T var1);

        protected static int getInputCount(Object[] objectList) {
            return CraftingRecipeValidator.getInputCount(Arrays.asList(objectList));
        }

        protected static int getInputCount(List<?> objectList) {
            int inputCount = 0;
            for (Object input : objectList) {
                if (input instanceof List) {
                    if (((List)input).isEmpty()) {
                        return -1;
                    }
                    ++inputCount;
                    continue;
                }
                if (input instanceof ItemStack) {
                    ItemStack itemStack = (ItemStack)input;
                    if (itemStack.func_190926_b()) continue;
                    ++inputCount;
                    continue;
                }
                if (input == null) continue;
                ++inputCount;
            }
            return inputCount;
        }
    }
}

