/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientListElement;
import mezz.jei.ingredients.IngredientListElementComparator;
import mezz.jei.startup.IModIdHelper;
import net.minecraftforge.fml.common.ProgressManager;

public final class IngredientListElementFactory {
    private IngredientListElementFactory() {
    }

    public static List<IIngredientListElement> createBaseList(IIngredientRegistry ingredientRegistry, IModIdHelper modIdHelper) {
        LinkedList<IIngredientListElement> ingredientListElements = new LinkedList<IIngredientListElement>();
        for (Class ingredientClass : ingredientRegistry.getRegisteredIngredientClasses()) {
            IngredientListElementFactory.addToBaseList(ingredientListElements, ingredientRegistry, ingredientClass, modIdHelper);
        }
        Collections.sort(ingredientListElements, IngredientListElementComparator.INSTANCE);
        return ingredientListElements;
    }

    public static <V> List<IIngredientListElement> createList(IIngredientRegistry ingredientRegistry, Class<V> ingredientClass, List<V> ingredients, IModIdHelper modIdHelper) {
        IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        IIngredientRenderer<V> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredientClass);
        ArrayList<IIngredientListElement> list = new ArrayList<IIngredientListElement>();
        for (V ingredient : ingredients) {
            IngredientListElement<V> ingredientListElement;
            if (ingredient == null || (ingredientListElement = IngredientListElement.create(ingredient, ingredientHelper, ingredientRenderer, modIdHelper)) == null) continue;
            list.add(ingredientListElement);
        }
        return list;
    }

    private static <V> void addToBaseList(List<IIngredientListElement> baseList, IIngredientRegistry ingredientRegistry, Class<V> ingredientClass, IModIdHelper modIdHelper) {
        IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        IIngredientRenderer<V> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredientClass);
        List<V> ingredients = ingredientRegistry.getIngredients(ingredientClass);
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)("Registering ingredients: " + ingredientClass.getSimpleName()), (int)ingredients.size());
        for (V ingredient : ingredients) {
            IngredientListElement<V> ingredientListElement;
            progressBar.step("");
            if (ingredient == null || (ingredientListElement = IngredientListElement.create(ingredient, ingredientHelper, ingredientRenderer, modIdHelper)) == null) continue;
            baseList.add(ingredientListElement);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }
}

