/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IIngredientListOverlay;
import mezz.jei.api.IItemListOverlay;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.SessionData;
import mezz.jei.gui.PageNavigation;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.ConfigButton;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.IngredientGridAll;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IPaged;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class IngredientListOverlay
implements IItemListOverlay,
IIngredientListOverlay,
IPaged,
IMouseHandler,
IShowsRecipeFocuses {
    private static final int BORDER_PADDING = 2;
    private static final int BUTTON_SIZE = 20;
    private static final int NAVIGATION_HEIGHT = 20;
    private static final int SEARCH_HEIGHT = 16;
    private final IngredientFilter ingredientFilter;
    private final NonNullList<ItemStack> highlightedStacks = NonNullList.func_191196_a();
    private final ConfigButton configButton;
    private final PageNavigation navigation;
    private final IngredientGrid contents;
    private final GuiTextFieldFilter searchField;
    private Set<Rectangle> guiExclusionAreas = Collections.emptySet();
    private Rectangle displayArea = new Rectangle();
    @Nullable
    private GuiProperties guiProperties;

    private static boolean hasRoom(GuiProperties guiProperties) {
        return guiProperties.getScreenWidth() - (guiProperties.getGuiLeft() + guiProperties.getGuiXSize()) >= 72;
    }

    private static boolean isSearchBarCentered(GuiProperties guiProperties) {
        return Config.isCenterSearchBarEnabled() && guiProperties.getGuiTop() + guiProperties.getGuiYSize() + 16 < guiProperties.getScreenHeight();
    }

    public IngredientListOverlay(IngredientFilter ingredientFilter, IIngredientRegistry ingredientRegistry) {
        this.ingredientFilter = ingredientFilter;
        this.contents = new IngredientGridAll(ingredientRegistry, ingredientFilter);
        this.searchField = new GuiTextFieldFilter(0, ingredientFilter);
        this.navigation = new PageNavigation(this, false);
        this.configButton = new ConfigButton(this);
        this.setKeyboardFocus(false);
    }

    public void rebuildItemFilter() {
        Log.info("Updating ingredient filter...", new Object[0]);
        long start_time = System.currentTimeMillis();
        this.ingredientFilter.modesChanged();
        Log.info("Updated  ingredient filter in {} ms", System.currentTimeMillis() - start_time);
        SessionData.setFirstItemIndex(0);
        this.updateLayout();
    }

    @Override
    public String getFilterText() {
        return Config.getFilterText();
    }

    @Override
    public ImmutableList<ItemStack> getFilteredStacks() {
        List<IIngredientListElement> elements = this.ingredientFilter.getIngredientList();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IIngredientListElement element : elements) {
            Object ingredient = element.getIngredient();
            if (!(ingredient instanceof ItemStack)) continue;
            builder.add((Object)((ItemStack)ingredient));
        }
        return builder.build();
    }

    @Override
    public void highlightStacks(Collection<ItemStack> stacks) {
        this.highlightedStacks.clear();
        this.highlightedStacks.addAll(stacks);
    }

    public NonNullList<ItemStack> getHighlightedStacks() {
        return this.highlightedStacks;
    }

    public boolean isEnabled() {
        return Config.isOverlayEnabled() && this.guiProperties != null && IngredientListOverlay.hasRoom(this.guiProperties);
    }

    public void updateScreen(@Nullable GuiScreen guiScreen) {
        GuiProperties guiProperties = GuiProperties.create(guiScreen);
        if (guiProperties == null) {
            this.guiProperties = null;
            this.setKeyboardFocus(false);
        } else if (this.guiProperties == null || !this.guiProperties.equals(guiProperties)) {
            Rectangle searchArea;
            this.guiProperties = guiProperties;
            int x = guiProperties.getGuiLeft() + guiProperties.getGuiXSize() + 2;
            int y = 2;
            int width = guiProperties.getScreenWidth() - x - 4;
            int height = guiProperties.getScreenHeight() - 2 - 4;
            this.displayArea = new Rectangle(x, 2, width, height);
            boolean searchBarCentered = IngredientListOverlay.isSearchBarCentered(guiProperties);
            int searchHeight = searchBarCentered ? 0 : 20;
            Rectangle contentsArea = new Rectangle(this.displayArea.x, this.displayArea.y + 20 + 2, this.displayArea.width, this.displayArea.height - 20 - searchHeight);
            this.contents.updateBounds(contentsArea, this.guiExclusionAreas);
            contentsArea = this.contents.getArea();
            this.displayArea.x = contentsArea.x;
            this.displayArea.width = contentsArea.width;
            Rectangle navigationArea = new Rectangle(this.displayArea.x, this.displayArea.y, this.displayArea.width, 20);
            this.navigation.updateBounds(navigationArea);
            if (searchBarCentered) {
                searchArea = new Rectangle(guiProperties.getGuiLeft() + 2, guiProperties.getScreenHeight() - 4 - 16, guiProperties.getGuiXSize() - 3 - 20, 16);
                this.searchField.updateBounds(searchArea);
            } else {
                searchArea = new Rectangle(this.displayArea.x + 2, this.displayArea.y + this.displayArea.height - 16, this.displayArea.width - 3 - 20, 16);
                this.searchField.updateBounds(searchArea);
            }
            int configButtonX = this.searchField.field_146209_f + this.searchField.field_146218_h + 1;
            int configButtonY = this.searchField.field_146210_g - 2;
            this.configButton.updateBounds(new Rectangle(configButtonX, configButtonY, 20, 20));
            this.updateLayout();
        }
    }

    private void updateLayout() {
        this.contents.updateLayout(this.guiExclusionAreas);
        int pageNum = this.contents.getPageNum();
        int pageCount = this.contents.getPageCount();
        this.navigation.updatePageState(pageNum, pageCount);
        this.searchField.update();
    }

    public void drawScreen(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.updateGuiExclusionAreas()) {
            this.updateLayout();
        }
        GlStateManager.func_179140_f();
        this.navigation.draw(minecraft, mouseX, mouseY);
        this.searchField.func_146194_f();
        this.contents.draw(minecraft, mouseX, mouseY);
        this.configButton.draw(minecraft, mouseX, mouseY);
    }

    public boolean updateGuiExclusionAreas() {
        Set<Rectangle> guiAreas = IngredientListOverlay.getGuiAreas();
        if (!guiAreas.equals(this.guiExclusionAreas)) {
            this.guiExclusionAreas = guiAreas;
            return true;
        }
        return false;
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        this.contents.drawTooltips(minecraft, mouseX, mouseY);
        this.configButton.drawTooltips(minecraft, mouseX, mouseY);
    }

    public void handleTick() {
        this.searchField.func_146178_a();
    }

    @Override
    public boolean nextPage() {
        if (this.contents.nextPage()) {
            this.updateLayout();
            return true;
        }
        return false;
    }

    @Override
    public boolean previousPage() {
        if (this.contents.previousPage()) {
            this.updateLayout();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.contents.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.contents.hasPrevious();
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        if (this.displayArea.contains(mouseX, mouseY) || this.searchField.isMouseOver(mouseX, mouseY) || this.configButton.isMouseOver(mouseX, mouseY)) {
            return !MathUtil.contains(this.guiExclusionAreas, mouseX, mouseY);
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        IClickedIngredient<?> clicked = this.contents.getIngredientUnderMouse(mouseX, mouseY);
        if (clicked != null) {
            this.setKeyboardFocus(false);
        }
        return clicked;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.isEnabled() && this.contents.canSetFocusWithMouse();
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            this.setKeyboardFocus(false);
            return false;
        }
        if (this.contents.handleMouseClicked(mouseX, mouseY)) {
            this.setKeyboardFocus(false);
            return true;
        }
        boolean buttonClicked = this.navigation.handleMouseClickedButtons(mouseX, mouseY);
        if (buttonClicked) {
            this.setKeyboardFocus(false);
            return true;
        }
        boolean searchClicked = this.searchField.isMouseOver(mouseX, mouseY);
        this.setKeyboardFocus(searchClicked);
        if (searchClicked) {
            boolean updated = this.searchField.handleMouseClicked(mouseX, mouseY, mouseButton);
            if (updated) {
                this.updateLayout();
            }
            return true;
        }
        return this.configButton.handleMouseClick(Minecraft.func_71410_x(), mouseX, mouseY);
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (scrollDelta < 0) {
            this.nextPage();
            return true;
        }
        if (scrollDelta > 0) {
            this.previousPage();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.searchField.func_146206_l();
    }

    public void setKeyboardFocus(boolean keyboardFocus) {
        this.searchField.func_146195_b(keyboardFocus);
    }

    public boolean onKeyPressed(char typedChar, int keyCode) {
        if (this.hasKeyboardFocus() && this.searchField.func_146201_a(typedChar, keyCode)) {
            boolean changed = Config.setFilterText(this.searchField.func_146179_b());
            if (changed) {
                SessionData.setFirstItemIndex(0);
                this.updateLayout();
            }
            return true;
        }
        if (KeyBindings.nextPage.isActiveAndMatches(keyCode)) {
            this.nextPage();
            return true;
        }
        if (KeyBindings.previousPage.isActiveAndMatches(keyCode)) {
            this.previousPage();
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ItemStack getStackUnderMouse() {
        Object ingredient = this.getIngredientUnderMouse();
        if (ingredient instanceof ItemStack) {
            return (ItemStack)ingredient;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        IIngredientListElement elementUnderMouse = this.contents.getElementUnderMouse();
        if (elementUnderMouse != null) {
            return elementUnderMouse.getIngredient();
        }
        return null;
    }

    @Override
    public void setFilterText(String filterText) {
        ErrorUtil.checkNotNull(filterText, "filterText");
        if (Config.setFilterText(filterText)) {
            this.onSetFilterText(filterText);
        }
    }

    public void onSetFilterText(String filterText) {
        this.searchField.func_146180_a(filterText);
        SessionData.setFirstItemIndex(0);
        this.updateLayout();
    }

    @Override
    public ImmutableList<ItemStack> getVisibleStacks() {
        ImmutableList.Builder visibleStacks = ImmutableList.builder();
        List<IIngredientListElement> visibleElements = this.contents.getVisibleElements();
        for (IIngredientListElement element : visibleElements) {
            Object ingredient = element.getIngredient();
            if (!(ingredient instanceof ItemStack)) continue;
            visibleStacks.add((Object)((ItemStack)ingredient));
        }
        return visibleStacks.build();
    }

    @Override
    public ImmutableList<Object> getVisibleIngredients() {
        ImmutableList.Builder visibleIngredients = ImmutableList.builder();
        List<IIngredientListElement> visibleElements = this.contents.getVisibleElements();
        for (IIngredientListElement element : visibleElements) {
            Object ingredient = element.getIngredient();
            visibleIngredients.add(ingredient);
        }
        return visibleIngredients.build();
    }

    private static Set<Rectangle> getGuiAreas() {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)currentScreen;
            JeiRuntime jeiRuntime = Internal.getRuntime();
            if (jeiRuntime != null) {
                HashSet<Rectangle> allGuiExtraAreas = new HashSet<Rectangle>();
                List<IAdvancedGuiHandler<GuiContainer>> activeAdvancedGuiHandlers = jeiRuntime.getActiveAdvancedGuiHandlers(guiContainer);
                for (IAdvancedGuiHandler<GuiContainer> advancedGuiHandler : activeAdvancedGuiHandlers) {
                    List<Rectangle> guiExtraAreas = advancedGuiHandler.getGuiExtraAreas(guiContainer);
                    if (guiExtraAreas == null) continue;
                    allGuiExtraAreas.addAll(guiExtraAreas);
                }
                return allGuiExtraAreas;
            }
        }
        return Collections.emptySet();
    }
}

