/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.ingredients.IngredientRegistry;

public class Ingredients
implements IIngredients {
    private final Map<Class, List<List>> inputs = new IdentityHashMap<Class, List<List>>();
    private final Map<Class, List<List>> outputs = new IdentityHashMap<Class, List<List>>();

    @Override
    public <T> void setInput(Class<? extends T> ingredientClass, T input) {
        this.setInputs(ingredientClass, Collections.singletonList(input));
    }

    @Override
    public <T> void setInputLists(Class<? extends T> ingredientClass, List<List<T>> inputs) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientHelper<T> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        ArrayList<List<? extends T>> expandedInputs = new ArrayList<List<? extends T>>();
        for (List<T> input : inputs) {
            List<? extends T> itemStacks = ingredientHelper.expandSubtypes(input);
            expandedInputs.add(itemStacks);
        }
        this.inputs.put(ingredientClass, expandedInputs);
    }

    @Override
    public <T> void setInputs(Class<? extends T> ingredientClass, List<T> input) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientHelper<T> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        ArrayList<List<? extends T>> expandedInputs = new ArrayList<List<? extends T>>();
        for (T input1 : input) {
            List<? extends T> itemStacks = ingredientHelper.expandSubtypes(Collections.singletonList(input1));
            expandedInputs.add(itemStacks);
        }
        this.inputs.put(ingredientClass, expandedInputs);
    }

    @Override
    public <T> void setOutput(Class<? extends T> ingredientClass, T output) {
        this.setOutputs(ingredientClass, Collections.singletonList(output));
    }

    @Override
    public <T> void setOutputs(Class<? extends T> ingredientClass, List<T> outputs) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientHelper<T> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        ArrayList<List<? extends T>> expandedOutputs = new ArrayList<List<? extends T>>();
        for (T output : outputs) {
            List<? extends T> expandedOutput = ingredientHelper.expandSubtypes(Collections.singletonList(output));
            expandedOutputs.add(expandedOutput);
        }
        this.outputs.put(ingredientClass, expandedOutputs);
    }

    @Override
    public <T> void setOutputLists(Class<? extends T> ingredientClass, List<List<T>> outputs) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientHelper<T> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        ArrayList<List<? extends T>> expandedOutputs = new ArrayList<List<? extends T>>();
        for (List<T> output : outputs) {
            List<? extends T> itemStacks = ingredientHelper.expandSubtypes(output);
            expandedOutputs.add(itemStacks);
        }
        this.outputs.put(ingredientClass, expandedOutputs);
    }

    @Override
    public <T> List<List<T>> getInputs(Class<? extends T> ingredientClass) {
        List<List<T>> inputs = this.inputs.get(ingredientClass);
        if (inputs == null) {
            return Collections.emptyList();
        }
        return inputs;
    }

    @Override
    public <T> List<List<T>> getOutputs(Class<? extends T> ingredientClass) {
        List<List<T>> outputs = this.outputs.get(ingredientClass);
        if (outputs == null) {
            return Collections.emptyList();
        }
        return outputs;
    }

    public Map<Class, List> getInputIngredients() {
        IdentityHashMap<Class, List> inputIngredients = new IdentityHashMap<Class, List>();
        for (Map.Entry<Class, List<List>> entry : this.inputs.entrySet()) {
            ArrayList flatIngredients = new ArrayList();
            for (List ingredients : entry.getValue()) {
                flatIngredients.addAll(ingredients);
            }
            inputIngredients.put(entry.getKey(), flatIngredients);
        }
        return inputIngredients;
    }

    public Map<Class, List> getOutputIngredients() {
        IdentityHashMap<Class, List> outputIngredients = new IdentityHashMap<Class, List>();
        for (Map.Entry<Class, List<List>> entry : this.outputs.entrySet()) {
            ArrayList flatIngredients = new ArrayList();
            for (List ingredients : entry.getValue()) {
                flatIngredients.addAll(ingredients);
            }
            outputIngredients.put(entry.getKey(), flatIngredients);
        }
        return outputIngredients;
    }
}

