package mezz.jei.library.plugins.vanilla.ingredients;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ItemStackListFactory {
	private static final Logger LOGGER = LogManager.getLogger();

	public static List<class_1799> create(StackHelper stackHelper) {
		final List<class_1799> itemList = new ArrayList<>();
		final Set<String> itemNameSet = new HashSet<>();

		for (class_1761 itemGroup : class_1761.field_7921) {
			if (itemGroup == class_1761.field_7925 || itemGroup == class_1761.field_7918) {
				continue;
			}
			class_2371<class_1799> creativeTabItemStacks = class_2371.method_10211();
			try {
				itemGroup.method_7738(creativeTabItemStacks);
			} catch (RuntimeException | LinkageError e) {
				LOGGER.error("Item Group crashed while getting items." +
					"Some items from this group will be missing from the ingredient list. {}", itemGroup, e);
			}
			for (class_1799 itemStack : creativeTabItemStacks) {
				if (itemStack.method_7960()) {
					LOGGER.error("Found an empty itemStack from creative tab: {}", itemGroup);
				} else {
					addItemStack(stackHelper, itemStack, itemList, itemNameSet);
				}
			}
		}
		return itemList;
	}

	private static void addItemStack(StackHelper stackHelper, class_1799 stack, List<class_1799> itemList, Set<String> itemNameSet) {
		//TODO: Test to make sure this is actually fixed in 1.17 and if so remove this check
		// Game freezes when loading player skulls, see https://bugs.mojang.com/browse/MC-65587
		if (stack.method_7909() == class_1802.field_8575) {
			return;
		}

		final String itemKey;

		try {
			itemKey = stackHelper.getUniqueIdentifierForStack(stack, UidContext.Ingredient);
		} catch (RuntimeException | LinkageError e) {
			String stackInfo = ErrorUtil.getItemStackInfo(stack);
			LOGGER.error("Couldn't get unique name for itemStack {}", stackInfo, e);
			return;
		}

		if (!itemNameSet.contains(itemKey)) {
			itemNameSet.add(itemKey);
			itemList.add(stack);
		}
	}

}
