package mezz.jei.library.plugins.vanilla.crafting;

import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_310;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_5357;
import net.minecraft.class_638;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class VanillaRecipes {
	private final class_1863 recipeManager;
	private final IIngredientManager ingredientManager;

	public VanillaRecipes(IIngredientManager ingredientManager) {
		class_310 minecraft = class_310.method_1551();
		ErrorUtil.checkNotNull(minecraft, "minecraft");
		class_638 world = minecraft.field_1687;
		ErrorUtil.checkNotNull(world, "minecraft world");
		this.recipeManager = world.method_8433();
		this.ingredientManager = ingredientManager;
	}

	public Map<Boolean, List<class_3955>> getCraftingRecipes(IRecipeCategory<class_3955> craftingCategory) {
		CategoryRecipeValidator<class_3955> validator = new CategoryRecipeValidator<>(craftingCategory, ingredientManager, 9);
		return recipeManager.method_30027(class_3956.field_17545)
			.stream()
			.filter(validator::isRecipeValid)
			.collect(Collectors.partitioningBy(validator::isRecipeHandled));
	}

	public List<class_3975> getStonecuttingRecipes(IRecipeCategory<class_3975> stonecuttingCategory) {
		CategoryRecipeValidator<class_3975> validator = new CategoryRecipeValidator<>(stonecuttingCategory, ingredientManager, 1);
		return getValidHandledRecipes(recipeManager, class_3956.field_17641, validator);
	}

	public List<class_3861> getFurnaceRecipes(IRecipeCategory<class_3861> furnaceCategory) {
		CategoryRecipeValidator<class_3861> validator = new CategoryRecipeValidator<>(furnaceCategory, ingredientManager, 1);
		return getValidHandledRecipes(recipeManager, class_3956.field_17546, validator);
	}

	public List<class_3862> getSmokingRecipes(IRecipeCategory<class_3862> smokingCategory) {
		CategoryRecipeValidator<class_3862> validator = new CategoryRecipeValidator<>(smokingCategory, ingredientManager, 1);
		return getValidHandledRecipes(recipeManager, class_3956.field_17548, validator);
	}

	public List<class_3859> getBlastingRecipes(IRecipeCategory<class_3859> blastingCategory) {
		CategoryRecipeValidator<class_3859> validator = new CategoryRecipeValidator<>(blastingCategory, ingredientManager, 1);
		return getValidHandledRecipes(recipeManager, class_3956.field_17547, validator);
	}

	public List<class_3920> getCampfireCookingRecipes(IRecipeCategory<class_3920> campfireCategory) {
		CategoryRecipeValidator<class_3920> validator = new CategoryRecipeValidator<>(campfireCategory, ingredientManager, 1);
		return getValidHandledRecipes(recipeManager, class_3956.field_17549, validator);
	}

	public List<class_5357> getSmithingRecipes(IRecipeCategory<class_5357> smithingCategory) {
		CategoryRecipeValidator<class_5357> validator = new CategoryRecipeValidator<>(smithingCategory, ingredientManager, 0);
		return getValidHandledRecipes(recipeManager, class_3956.field_25388, validator);
	}

	private static <C extends class_1263, T extends class_1860<C>> List<T> getValidHandledRecipes(
		class_1863 recipeManager,
		class_3956<T> recipeType,
		CategoryRecipeValidator<T> validator
	) {
		return recipeManager.method_30027(recipeType)
			.stream()
			.filter(r -> validator.isRecipeValid(r) && validator.isRecipeHandled(r))
			.toList();
	}

}
