package mezz.jei.library.plugins.vanilla.cooking;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.common.Constants;
import net.minecraft.class_1799;
import net.minecraft.class_1874;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;

import static mezz.jei.api.recipe.RecipeIngredientRole.INPUT;
import static mezz.jei.api.recipe.RecipeIngredientRole.OUTPUT;

public abstract class AbstractCookingCategory<T extends class_1874> extends FurnaceVariantCategory<T> {
	private final IDrawable background;
	private final int regularCookTime;
	private final IDrawable icon;
	private final class_2561 localizedName;
	private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

	public AbstractCookingCategory(IGuiHelper guiHelper, class_2248 icon, String translationKey, int regularCookTime) {
		super(guiHelper);
		this.background = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 114, 82, 54);
		this.regularCookTime = regularCookTime;
		this.icon = guiHelper.createDrawableItemStack(new class_1799(icon));
		this.localizedName = class_2561.method_43471(translationKey);
		this.cachedArrows = CacheBuilder.newBuilder()
			.maximumSize(25)
			.build(new CacheLoader<>() {
				@Override
				public IDrawableAnimated load(Integer cookTime) {
					return guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 82, 128, 24, 17)
						.buildAnimated(cookTime, IDrawableAnimated.StartDirection.LEFT, false);
				}
			});
	}

	protected IDrawableAnimated getArrow(T recipe) {
		int cookTime = recipe.method_8167();
		if (cookTime <= 0) {
			cookTime = regularCookTime;
		}
		return this.cachedArrows.getUnchecked(cookTime);
	}

	@Override
	public IDrawable getBackground() {
		return background;
	}

	@Override
	public IDrawable getIcon() {
		return icon;
	}

	@Override
	public void draw(T recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		animatedFlame.draw(poseStack, 1, 20);

		IDrawableAnimated arrow = getArrow(recipe);
		arrow.draw(poseStack, 24, 18);

		drawExperience(recipe, poseStack, 0);
		drawCookTime(recipe, poseStack, 45);
	}

	protected void drawExperience(T recipe, class_4587 poseStack, int y) {
		float experience = recipe.method_8171();
		if (experience > 0) {
			class_2561 experienceString = class_2561.method_43469("gui.jei.category.smelting.experience", experience);
			class_310 minecraft = class_310.method_1551();
			class_327 fontRenderer = minecraft.field_1772;
			int stringWidth = fontRenderer.method_27525(experienceString);
			fontRenderer.method_30883(poseStack, experienceString, getWidth() - stringWidth, y, 0xFF808080);
		}
	}

	protected void drawCookTime(T recipe, class_4587 poseStack, int y) {
		int cookTime = recipe.method_8167();
		if (cookTime > 0) {
			int cookTimeSeconds = cookTime / 20;
			class_2561 timeString = class_2561.method_43469("gui.jei.category.smelting.time.seconds", cookTimeSeconds);
			class_310 minecraft = class_310.method_1551();
			class_327 fontRenderer = minecraft.field_1772;
			int stringWidth = fontRenderer.method_27525(timeString);
			fontRenderer.method_30883(poseStack, timeString, getWidth() - stringWidth, y, 0xFF808080);
		}
	}

	@Override
	public class_2561 getTitle() {
		return localizedName;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
		builder.addSlot(INPUT, 1, 1)
			.addIngredients(recipe.method_8117().get(0));

		builder.addSlot(OUTPUT, 61, 19)
			.addItemStack(recipe.method_8110());
	}

	@Override
	public boolean isHandled(T recipe) {
		return !recipe.method_8118();
	}
}
