package mezz.jei.library.plugins.vanilla.anvil;

import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.common.Constants;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_5357;

public class SmithingRecipeCategory implements IRecipeCategory<class_5357> {
	private final IDrawable background;
	private final IDrawable icon;

	public SmithingRecipeCategory(IGuiHelper guiHelper) {
		background = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 168, 125, 18);
		icon = guiHelper.createDrawableItemStack(new class_1799(class_2246.field_16329));
	}

	@Override
	public RecipeType<class_5357> getRecipeType() {
		return RecipeTypes.SMITHING;
	}

	@Override
	public class_2561 getTitle() {
		return class_2246.field_16329.method_9518();
	}

	@Override
	public IDrawable getBackground() {
		return background;
	}

	@Override
	public IDrawable getIcon() {
		return icon;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, class_5357 recipe, IFocusGroup focuses) {
		IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();

		builder.addSlot(RecipeIngredientRole.INPUT, 1, 1)
			.addIngredients(recipeHelper.getBase(recipe));

		builder.addSlot(RecipeIngredientRole.INPUT, 50, 1)
			.addIngredients(recipeHelper.getAddition(recipe));

		builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1)
			.addItemStack(recipe.method_8110());
	}

	@Override
	public boolean isHandled(class_5357 recipe) {
		return !recipe.method_8118();
	}
}
