package mezz.jei.library.plugins.debug;

import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.Services;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public class FluidSubtypeHandlerTest<T> implements IIngredientSubtypeInterpreter<T> {
	private final IIngredientTypeWithSubtypes<class_3611, T> type;

	public FluidSubtypeHandlerTest(IIngredientTypeWithSubtypes<class_3611, T> type) {
		this.type = type;
	}

	@Override
	public String apply(T fluidStack, UidContext context) {
		class_3611 fluid = type.getBase(fluidStack);
		return Services.PLATFORM
			.getRegistry(class_2378.field_25103)
			.getRegistryName(fluid)
			.map(class_2960::toString)
			.orElseThrow(() -> {
				throw new IllegalArgumentException("Fluid has no registry name: " + fluid);
			});
	}
}
