package mezz.jei.library.gui;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.input.ClickableIngredient;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.library.ingredients.TypedIngredient;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class ScreenHelper implements IScreenHelper {
	private final IIngredientManager ingredientManager;
	private final List<IGlobalGuiHandler> globalGuiHandlers;
	private final GuiContainerHandlers guiContainerHandlers;
	private final Map<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers;
	private final Map<Class<?>, IScreenHandler<?>> guiScreenHandlers;

	public ScreenHelper(
		IIngredientManager ingredientManager,
		List<IGlobalGuiHandler> globalGuiHandlers,
		GuiContainerHandlers guiContainerHandlers,
		Map<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers,
		Map<Class<?>, IScreenHandler<?>> guiScreenHandlers
	) {
		this.ingredientManager = ingredientManager;
		this.globalGuiHandlers = globalGuiHandlers;
		this.guiContainerHandlers = guiContainerHandlers;
		this.ghostIngredientHandlers = ghostIngredientHandlers;
		this.guiScreenHandlers = guiScreenHandlers;
	}

	@Override
	public <T extends class_437> Optional<IGuiProperties> getGuiProperties(T screen) {
		{
			@SuppressWarnings("unchecked")
			IScreenHandler<T> handler = (IScreenHandler<T>) guiScreenHandlers.get(screen.getClass());
			if (handler != null) {
				IGuiProperties properties = handler.apply(screen);
				return Optional.ofNullable(properties);
			}
		}
		for (Map.Entry<Class<?>, IScreenHandler<?>> entry : guiScreenHandlers.entrySet()) {
			Class<?> guiScreenClass = entry.getKey();
			if (guiScreenClass.isInstance(screen)) {
				@SuppressWarnings("unchecked")
				IScreenHandler<T> handler = (IScreenHandler<T>) entry.getValue();
				if (handler != null) {
					IGuiProperties properties = handler.apply(screen);
					return Optional.ofNullable(properties);
				}
			}
		}
		return Optional.empty();
	}

	@Override
	public Stream<class_768> getGuiExclusionAreas(class_437 screen) {
		Stream<class_768> globalGuiHandlerExclusionAreas = globalGuiHandlers.stream()
			.map(IGlobalGuiHandler::getGuiExtraAreas)
			.flatMap(Collection::stream);

		if (screen instanceof class_465<?> guiContainer) {
			Stream<class_768> guiExtraAreas = this.guiContainerHandlers.getGuiExtraAreas(guiContainer);
			return Stream.concat(globalGuiHandlerExclusionAreas, guiExtraAreas);
		} else {
			return globalGuiHandlerExclusionAreas;
		}
	}

	@Override
	public Stream<IClickableIngredient<?>> getClickableIngredientUnderMouse(class_437 screen, double mouseX, double mouseY) {
		return Stream.concat(
			getPluginsIngredientUnderMouse(screen, mouseX, mouseY),
			getSlotIngredientUnderMouse(screen).stream()
		);
	}

	private Optional<IClickableIngredient<?>> getSlotIngredientUnderMouse(class_437 guiScreen) {
		if (!(guiScreen instanceof class_465<?> guiContainer)) {
			return Optional.empty();
		}
		IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
		return screenHelper.getSlotUnderMouse(guiContainer)
			.flatMap(slot -> getClickedIngredient(slot, guiContainer));
	}

	@SuppressWarnings("deprecation")
	private Stream<IClickableIngredient<?>> getPluginsIngredientUnderMouse(class_437 guiScreen, double mouseX, double mouseY) {
		Stream<IClickableIngredient<?>> globalIngredients = this.globalGuiHandlers.stream()
			.map(a -> a.getClickableIngredientUnderMouse(mouseX, mouseY)
				.or(() ->
					Optional.ofNullable(a.getIngredientUnderMouse(mouseX, mouseY))
						.flatMap(i -> createClickedIngredient(i, guiScreen))
				)
			)
			.flatMap(Optional::stream);

		if (guiScreen instanceof class_465<?> guiContainer) {
			Stream<IClickableIngredient<?>> containerIngredients = getGuiContainerHandlerIngredients(guiContainer, mouseX, mouseY);
			return Stream.concat(
				containerIngredients,
				globalIngredients
			);
		}
		return globalIngredients;
	}

	private Optional<IClickableIngredient<?>> getClickedIngredient(class_1735 slot, class_465<?> guiContainer) {
		class_1799 stack = slot.method_7677();
		return TypedIngredient.createAndFilterInvalid(ingredientManager, VanillaTypes.ITEM_STACK, stack)
			.map(typedIngredient -> {
				IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
				ImmutableRect2i slotArea = new ImmutableRect2i(
					screenHelper.getGuiLeft(guiContainer) + slot.field_7873,
					screenHelper.getGuiTop(guiContainer) + slot.field_7872,
					16,
					16
				);
				return new ClickableIngredient<>(typedIngredient, slotArea);
			});
	}

	@SuppressWarnings("deprecation")
	private <T extends class_465<?>> Stream<IClickableIngredient<?>> getGuiContainerHandlerIngredients(T guiContainer, double mouseX, double mouseY) {
		return this.guiContainerHandlers.getActiveGuiHandlerStream(guiContainer)
			.map(a ->
				a.getClickableIngredientUnderMouse(guiContainer, mouseX, mouseY)
					.or(() ->
						Optional.ofNullable(a.getIngredientUnderMouse(guiContainer, mouseX, mouseY))
							.flatMap(i -> createClickedIngredient(i, guiContainer))
					)
			)
			.flatMap(Optional::stream);
	}

	@Override
	public <T extends class_437> Optional<IGhostIngredientHandler<T>> getGhostIngredientHandler(T guiScreen) {
		{
			@SuppressWarnings("unchecked")
			IGhostIngredientHandler<T> handler = (IGhostIngredientHandler<T>) ghostIngredientHandlers.get(guiScreen.getClass());
			if (handler != null) {
				return Optional.of(handler);
			}
		}
		for (Map.Entry<Class<?>, IGhostIngredientHandler<?>> entry : ghostIngredientHandlers.entrySet()) {
			Class<?> guiScreenClass = entry.getKey();
			if (guiScreenClass.isInstance(guiScreen)) {
				@SuppressWarnings("unchecked")
				IGhostIngredientHandler<T> handler = (IGhostIngredientHandler<T>) entry.getValue();
				if (handler != null) {
					return Optional.of(handler);
				}
			}
		}
		return Optional.empty();
	}

	private <T> Optional<IClickableIngredient<?>> createClickedIngredient(@Nullable T ingredient, class_437 guiScreen) {
		if (ingredient == null) {
			return Optional.empty();
		}
		return TypedIngredient.createAndFilterInvalid(ingredientManager, ingredient)
			.map(typedIngredient -> {
				ImmutableRect2i area = getSlotArea(typedIngredient, guiScreen).orElse(ImmutableRect2i.EMPTY);
				return new ClickableIngredient<>(typedIngredient, area);
			});
	}

	@Override
	public Stream<IGuiClickableArea> getGuiClickableArea(class_465<?> guiContainer, double guiMouseX, double guiMouseY) {
		return this.guiContainerHandlers.getGuiClickableArea(guiContainer, guiMouseX, guiMouseY);
	}

	public static <T> Optional<ImmutableRect2i> getSlotArea(ITypedIngredient<T> typedIngredient, class_437 guiScreen) {
		if (!(guiScreen instanceof class_465<?> guiContainer)) {
			return Optional.empty();
		}
		IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
		return screenHelper.getSlotUnderMouse(guiContainer)
			.flatMap(slotUnderMouse ->
				typedIngredient.getItemStack()
					.filter(i -> class_1799.method_7973(slotUnderMouse.method_7677(), i))
					.map(i ->
						new ImmutableRect2i(
							screenHelper.getGuiLeft(guiContainer) + slotUnderMouse.field_7873,
							screenHelper.getGuiTop(guiContainer) + slotUnderMouse.field_7872,
							16,
							16
						)
					)
			);
	}

}
