package mezz.jei.library.config.serializers;

import mezz.jei.core.config.file.serializers.DeserializeResult;
import mezz.jei.core.config.file.serializers.IConfigValueSerializer;
import net.minecraft.class_124;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public class ChatFormattingSerializer implements IConfigValueSerializer<List<class_124>> {
    public static final ChatFormattingSerializer INSTANCE = new ChatFormattingSerializer();

    private ChatFormattingSerializer() {}

    @Override
    public String serialize(List<class_124> value) {
        return value.stream()
            .map(class_124::method_537)
            .collect(Collectors.joining(" "));
    }

    @Override
    public DeserializeResult<List<class_124>> deserialize(String string) {
        string = string.trim();
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.isEmpty()) {
            return new DeserializeResult<>(List.of());
        }
        List<String> errors = new ArrayList<>();
        String[] strings = string.split(" ");
        List<class_124> result = Arrays.stream(strings)
            .<class_124>mapMulti((s, c) -> {
                class_124 chatFormatting = class_124.method_533(s);
                if (chatFormatting != null) {
                    c.accept(chatFormatting);
                } else {
                    errors.add("No Chat Formatting found for name: '%s'".formatted(s));
                }
            })
            .toList();
        return new DeserializeResult<>(result, errors);
    }

    @Override
    public String getValidValuesDescription() {
        EnumSet<class_124> validFormatting = EnumSet.allOf(class_124.class);
        validFormatting.remove(class_124.field_1070);

        List<class_124> validColors = new ArrayList<>();
        List<class_124> validFormats = new ArrayList<>();

        for (class_124 chatFormatting : validFormatting) {
            if (chatFormatting.method_543()) {
                validColors.add(chatFormatting);
            } else if (chatFormatting.method_542()) {
                validFormats.add(chatFormatting);
            }
        }

        return """
            A chat formatting string.
            Use these formatting colors:
            %s
            With these formatting options:
            %s""".formatted(serialize(validColors), serialize(validFormats));
    }
}
