package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.ClickableIngredientInternal;
import mezz.jei.common.input.IClickableIngredientInternal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.config.IClientConfig;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class RecipesGui extends class_437 implements IRecipesGui, IRecipeFocusSource, IRecipeLogicStateListener {
	private static final int borderPadding = 6;
	private static final int innerPadding = 14;
	private static final int buttonWidth = 13;
	private static final int buttonHeight = 13;

	private final IRecipeTransferManager recipeTransferManager;
	private final IModIdHelper modIdHelper;
	private final IClientConfig clientConfig;
	private final IInternalKeyMappings keyBindings;
	private final Textures textures;
	private final IFocusFactory focusFactory;
	private final IIngredientManager ingredientManager;

	private int headerHeight;

	/* Internal logic for the gui, handles finding recipes */
	private final IRecipeGuiLogic logic;

	/* List of RecipeLayout to display */
	private final List<IRecipeLayoutDrawable<?>> recipeLayouts = new ArrayList<>();

	private String pageString = "1/1";
	private class_2561 title = class_5244.field_39003;
	private final DrawableNineSliceTexture background;

	private final RecipeCatalysts recipeCatalysts;
	private final RecipeGuiTabs recipeGuiTabs;

	private final List<RecipeTransferButton> recipeTransferButtons;

	private final GuiIconButtonSmall nextRecipeCategory;
	private final GuiIconButtonSmall previousRecipeCategory;
	private final GuiIconButtonSmall nextPage;
	private final GuiIconButtonSmall previousPage;

	@Nullable
	private class_437 parentScreen;
	private ImmutableRect2i area = ImmutableRect2i.EMPTY;
	private ImmutableRect2i titleArea = ImmutableRect2i.EMPTY;
	private ImmutableRect2i titleStringArea = ImmutableRect2i.EMPTY;

	private boolean init = false;

	public RecipesGui(
		IRecipeManager recipeManager,
		IRecipeTransferManager recipeTransferManager,
		IIngredientManager ingredientManager,
		IModIdHelper modIdHelper,
		IClientConfig clientConfig,
		Textures textures,
		IInternalKeyMappings keyBindings,
		IFocusFactory focusFactory
	) {
		super(class_2561.method_43470("Recipes"));
		this.textures = textures;
		this.recipeTransferButtons = new ArrayList<>();
		this.recipeTransferManager = recipeTransferManager;
		this.ingredientManager = ingredientManager;
		this.modIdHelper = modIdHelper;
		this.clientConfig = clientConfig;
		this.keyBindings = keyBindings;
		this.logic = new RecipeGuiLogic(recipeManager, recipeTransferManager, this, focusFactory);
		this.recipeCatalysts = new RecipeCatalysts(textures, recipeManager);
		this.recipeGuiTabs = new RecipeGuiTabs(this.logic, textures, ingredientManager);
		this.focusFactory = focusFactory;
		this.field_22787 = class_310.method_1551();

		IDrawableStatic arrowNext = textures.getArrowNext();
		IDrawableStatic arrowPrevious = textures.getArrowPrevious();

		nextRecipeCategory = new GuiIconButtonSmall(0, 0, buttonWidth, buttonHeight, arrowNext, b -> logic.nextRecipeCategory(), textures);
		previousRecipeCategory = new GuiIconButtonSmall(0, 0, buttonWidth, buttonHeight, arrowPrevious, b -> logic.previousRecipeCategory(), textures);
		nextPage = new GuiIconButtonSmall(0, 0, buttonWidth, buttonHeight, arrowNext, b -> logic.nextPage(), textures);
		previousPage = new GuiIconButtonSmall(0, 0, buttonWidth, buttonHeight, arrowPrevious, b -> logic.previousPage(), textures);

		background = textures.getRecipeGuiBackground();
	}

	private static void drawCenteredStringWithShadow(class_4587 poseStack, class_327 font, String string, ImmutableRect2i area) {
		ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, string);
		font.method_1720(poseStack, string, textArea.getX(), textArea.getY(), 0xFFFFFFFF);
	}

	private static void drawCenteredStringWithShadow(class_4587 poseStack, class_327 font, class_2561 text, ImmutableRect2i area) {
		ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, text);
		font.method_30881(poseStack, text, textArea.getX(), textArea.getY(), 0xFFFFFFFF);
	}

	public ImmutableRect2i getArea() {
		return this.area;
	}

	public int getRecipeCatalystExtraWidth() {
		if (recipeCatalysts.isEmpty()) {
			return 0;
		}
		return recipeCatalysts.getWidth();
	}

	@Override
	public boolean method_25421() {
		return false;
	}

	@Override
	public void method_25426() {
		super.method_25426();

		final int xSize = 198;
		int ySize;
		if (this.clientConfig.isCenterSearchBarEnabled()) {
			ySize = this.field_22790 - 76;
		} else {
			ySize = this.field_22790 - 68;
		}
		int extraSpace = 0;
		final int maxHeight = this.clientConfig.getMaxRecipeGuiHeight();
		if (ySize > maxHeight) {
			extraSpace = ySize - maxHeight;
			ySize = maxHeight;
		}

		final int guiLeft = (this.field_22789 - xSize) / 2;
		final int guiTop = RecipeGuiTab.TAB_HEIGHT + 21 + (extraSpace / 2);

		this.area = new ImmutableRect2i(guiLeft, guiTop, xSize, ySize);

		final int rightButtonX = guiLeft + xSize - borderPadding - buttonWidth;
		final int leftButtonX = guiLeft + borderPadding;

		int titleHeight = field_22793.field_2000 + borderPadding;
		int recipeClassButtonTop = guiTop + titleHeight - buttonHeight + 2;
		nextRecipeCategory.field_22760 = rightButtonX;
		nextRecipeCategory.field_22761 = recipeClassButtonTop;
		previousRecipeCategory.field_22760 = leftButtonX;
		previousRecipeCategory.field_22761 = recipeClassButtonTop;

		int pageButtonTop = recipeClassButtonTop + buttonHeight + 2;
		nextPage.field_22760 = rightButtonX;
		nextPage.field_22761 = pageButtonTop;
		previousPage.field_22760 = leftButtonX;
		previousPage.field_22761 = pageButtonTop;

		this.headerHeight = (pageButtonTop + buttonHeight) - guiTop;
		this.titleArea = MathUtil.union(previousRecipeCategory.getArea(), nextRecipeCategory.getArea())
			.cropLeft(previousRecipeCategory.method_25368() + innerPadding)
			.cropRight(nextRecipeCategory.method_25368() + innerPadding);

		this.method_37063(nextRecipeCategory);
		this.method_37063(previousRecipeCategory);
		this.method_37063(nextPage);
		this.method_37063(previousPage);

		this.init = true;
		updateLayout();
	}

	@Override
	public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
		if (field_22787 == null) {
			return;
		}
		method_25420(poseStack);
		RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
		final int x = area.getX();
		final int y = area.getY();
		final int width = area.getWidth();
		final int height = area.getHeight();
		this.background.draw(poseStack, x, y, width, height);

		RenderSystem.disableBlend();

		method_25294(poseStack,
			x + borderPadding + buttonWidth,
			nextRecipeCategory.field_22761,
			x + width - borderPadding - buttonWidth,
			nextRecipeCategory.field_22761 + buttonHeight,
			0x30000000);
		method_25294(poseStack,
			x + borderPadding + buttonWidth,
			nextPage.field_22761,
			x + width - borderPadding - buttonWidth,
			nextPage.field_22761 + buttonHeight,
			0x30000000);

		RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);

		drawCenteredStringWithShadow(poseStack, field_22793, field_22785, titleArea);

		ImmutableRect2i pageArea = MathUtil.union(previousPage.getArea(), nextPage.getArea());
		drawCenteredStringWithShadow(poseStack, field_22793, pageString, pageArea);

		nextRecipeCategory.method_25394(poseStack, mouseX, mouseY, partialTicks);
		previousRecipeCategory.method_25394(poseStack, mouseX, mouseY, partialTicks);
		nextPage.method_25394(poseStack, mouseX, mouseY, partialTicks);
		previousPage.method_25394(poseStack, mouseX, mouseY, partialTicks);

		Optional<IRecipeLayoutDrawable<?>> hoveredRecipeLayout = drawLayouts(poseStack, mouseX, mouseY);
		Optional<IRecipeSlotDrawable> hoveredRecipeCatalyst = recipeCatalysts.draw(poseStack, mouseX, mouseY);

		recipeGuiTabs.draw(field_22787, poseStack, mouseX, mouseY, modIdHelper);

		for (RecipeTransferButton button : recipeTransferButtons) {
			button.drawToolTip(poseStack, mouseX, mouseY);
		}
		RenderSystem.disableBlend();

		hoveredRecipeLayout.ifPresent(l -> l.drawOverlays(poseStack, mouseX, mouseY));
		hoveredRecipeCatalyst.ifPresent(h -> h.drawHoverOverlays(poseStack));

		hoveredRecipeCatalyst.ifPresent(h ->
			h.getDisplayedIngredient()
				.ifPresent(i -> {
					List<class_2561> tooltip = h.getTooltip();
					tooltip = modIdHelper.addModNameToIngredientTooltip(tooltip, i);
					TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY, i, ingredientManager);
				})
		);
		RenderSystem.enableDepthTest();

		if (titleStringArea.contains(mouseX, mouseY) && !logic.hasAllCategories()) {
			class_5250 showAllRecipesString = class_2561.method_43471("jei.tooltip.show.all.recipes");
			TooltipRenderer.drawHoveringText(poseStack, List.of(showAllRecipesString), mouseX, mouseY);
		}
	}

	private Optional<IRecipeLayoutDrawable<?>> drawLayouts(class_4587 poseStack, int mouseX, int mouseY) {
		IRecipeLayoutDrawable<?> hoveredLayout = null;
		for (IRecipeLayoutDrawable<?> recipeLayout : recipeLayouts) {
			if (recipeLayout.isMouseOver(mouseX, mouseY)) {
				hoveredLayout = recipeLayout;
			}
			recipeLayout.drawRecipe(poseStack, mouseX, mouseY);
		}

		class_310 minecraft = class_310.method_1551();
		float partialTicks = minecraft.method_1488();
		for (RecipeTransferButton button : recipeTransferButtons) {
			button.method_25394(poseStack, mouseX, mouseY, partialTicks);
		}
		RenderSystem.disableBlend();
		return Optional.ofNullable(hoveredLayout);
	}

	@Override
	public void method_25393() {
		super.method_25393();

		Optional.ofNullable(field_22787)
			.map(minecraft -> minecraft.field_1724)
			.ifPresent(localPlayer -> {
				class_1703 container = getParentContainer().orElse(null);
				List<RecipeTransferButton> transferButtons = this.recipeTransferButtons;
				for (int i = 0; i < transferButtons.size(); i++) {
					IRecipeLayoutDrawable<?> recipeLayout = recipeLayouts.get(i);
					RecipeTransferButton button = transferButtons.get(i);
					class_768 buttonArea = recipeLayout.getRecipeTransferButtonArea();
					button.update(buttonArea, recipeTransferManager, container, localPlayer);
				}
			});
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		if (field_22787 != null && field_22787.field_1755 == this) {
			if (this.area.contains(mouseX, mouseY)) {
				return true;
			}
			for (IRecipeLayoutDrawable<?> recipeLayout : this.recipeLayouts) {
				if (recipeLayout.isMouseOver(mouseX, mouseY)) {
					return true;
				}
			}
		}
		return false;
	}

	@Override
	public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
		if (isOpen()) {
			return Stream.concat(
				recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY),
				getRecipeLayoutsIngredientUnderMouse(mouseX, mouseY)
			);
		}
		return Stream.empty();
	}

	private Stream<IClickableIngredientInternal<?>> getRecipeLayoutsIngredientUnderMouse(double mouseX, double mouseY) {
		return this.recipeLayouts.stream()
			.map(recipeLayout -> getRecipeLayoutIngredientUnderMouse(recipeLayout, mouseX, mouseY))
			.flatMap(Optional::stream);
	}

	private static Optional<IClickableIngredientInternal<?>> getRecipeLayoutIngredientUnderMouse(IRecipeLayoutDrawable<?> recipeLayout, double mouseX, double mouseY) {
		return recipeLayout.getRecipeSlotUnderMouse(mouseX, mouseY)
			.flatMap(recipeSlot -> getClickedIngredient(recipeLayout, recipeSlot));
	}

	private static Optional<IClickableIngredientInternal<?>> getClickedIngredient(IRecipeLayoutDrawable<?> recipeLayout, IRecipeSlotDrawable recipeSlot) {
		return recipeSlot.getDisplayedIngredient()
			.map(displayedIngredient -> {
				ImmutableRect2i area = absoluteClickedArea(recipeLayout, recipeSlot.getRect());
				return new ClickableIngredientInternal<>(displayedIngredient, area, false, true);
			});
	}

	/**
	 * Converts from relative recipeLayout coordinates to absolute screen coordinates
	 */
	private static ImmutableRect2i absoluteClickedArea(IRecipeLayoutDrawable<?> recipeLayout, class_768 area) {
		class_768 layoutArea = recipeLayout.getRect();

		return new ImmutableRect2i(
			area.method_3321() + layoutArea.method_3321(),
			area.method_3322() + layoutArea.method_3322(),
			area.method_3319(),
			area.hashCode()
		);
	}

	@Override
	public boolean method_25401(double scrollX, double scrollY, double scrollDelta) {
		final double x = MouseUtil.getX();
		final double y = MouseUtil.getY();
		if (method_25405(x, y)) {
			if (scrollDelta < 0) {
				logic.nextPage();
				return true;
			} else if (scrollDelta > 0) {
				logic.previousPage();
				return true;
			}
		}
		return super.method_25401(scrollX, scrollY, scrollDelta);
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
		boolean handled = UserInput.fromVanilla(mouseX, mouseY, mouseButton, InputType.IMMEDIATE)
			.map(this::handleInput)
			.orElse(false);

		if (handled) {
			return true;
		}
		return super.method_25402(mouseX, mouseY, mouseButton);
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		UserInput input = UserInput.fromVanilla(keyCode, scanCode, modifiers, InputType.IMMEDIATE);
		return handleInput(input);
	}

	private boolean handleInput(UserInput input) {
		double mouseX = input.getMouseX();
		double mouseY = input.getMouseY();
		if (method_25405(mouseX, mouseY)) {
			if (titleStringArea.contains(mouseX, mouseY)) {
				if (input.is(keyBindings.getLeftClick()) && logic.setCategoryFocus()) {
					return true;
				}
			} else {
				for (IRecipeLayoutDrawable<?> recipeLayout : recipeLayouts) {
					if (handleRecipeLayoutInput(recipeLayout, input)) {
						return true;
					}
				}
			}
		}

		IUserInputHandler handler = recipeGuiTabs.getInputHandler();
		if (handler.handleUserInput(this, input, keyBindings).isPresent()) {
			return true;
		}

		class_310 minecraft = class_310.method_1551();
		if (input.is(keyBindings.getCloseRecipeGui()) || input.is(minecraft.field_1690.field_1822)) {
			method_25419();
			return true;
		} else if (input.is(keyBindings.getRecipeBack())) {
			back();
			return true;
		} else if (input.is(keyBindings.getNextCategory())) {
			logic.nextRecipeCategory();
			return true;
		} else if (input.is(keyBindings.getPreviousCategory())) {
			logic.previousRecipeCategory();
			return true;
		} else if (input.is(keyBindings.getNextRecipePage())) {
			logic.nextPage();
			return true;
		} else if (input.is(keyBindings.getPreviousRecipePage())) {
			logic.previousPage();
			return true;
		}
		return false;
	}

	private <R> boolean handleRecipeLayoutInput(IRecipeLayoutDrawable<R> recipeLayout, UserInput input) {
		if (!method_25405(input.getMouseX(), input.getMouseY())) {
			return false;
		}

		class_768 recipeArea = recipeLayout.getRect();
		double recipeMouseX = input.getMouseX() - recipeArea.method_3321();
		double recipeMouseY = input.getMouseY() - recipeArea.method_3322();
		R recipe = recipeLayout.getRecipe();
		IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
		if (recipeCategory.handleInput(recipe, recipeMouseX, recipeMouseY, input.getKey())) {
			return true;
		}

		if (input.is(keyBindings.getCopyRecipeId())) {
			return handleCopyRecipeId(recipeLayout);
		}
		return false;
	}

	private <R> boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout) {
		class_310 minecraft = class_310.method_1551();
		class_746 player = minecraft.field_1724;
		IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
		R recipe = recipeLayout.getRecipe();
		class_2960 registryName = recipeCategory.getRegistryName(recipe);
		if (registryName == null) {
			class_5250 message = class_2561.method_43471("jei.message.copy.recipe.id.failure");
			if (player != null) {
				player.method_7353(message, false);
			}
			return false;
		}
		String recipeId = registryName.toString();
		minecraft.field_1774.method_1455(recipeId);
		class_5250 message = class_2561.method_43469("jei.message.copy.recipe.id.success", recipeId);
		if (player != null) {
			player.method_7353(message, false);
		}
		return true;
	}

	public boolean isOpen() {
		return field_22787 != null && field_22787.field_1755 == this;
	}

	private void open() {
		if (field_22787 != null) {
			if (!isOpen()) {
				parentScreen = field_22787.field_1755;
			}
			field_22787.method_1507(this);
		}
	}

	@Override
	public void method_25419() {
		if (isOpen() && field_22787 != null) {
			field_22787.method_1507(parentScreen);
			parentScreen = null;
			logic.clearHistory();
			return;
		}
		super.method_25419();
	}

	@Override
	public void show(List<IFocus<?>> focuses) {
		IFocusGroup checkedFocuses = focusFactory.createFocusGroup(focuses);
		if (logic.setFocus(checkedFocuses)) {
			open();
		}
	}

	@Override
	public void showTypes(List<RecipeType<?>> recipeTypes) {
		ErrorUtil.checkNotEmpty(recipeTypes, "recipeTypes");

		if (logic.setCategoryFocus(recipeTypes)) {
			open();
		}
	}

	@Override
	public <T> Optional<T> getIngredientUnderMouse(IIngredientType<T> ingredientType) {
		double x = MouseUtil.getX();
		double y = MouseUtil.getY();

		return getIngredientUnderMouse(x, y)
			.map(IClickableIngredientInternal::getTypedIngredient)
			.flatMap(i -> i.getIngredient(ingredientType).stream())
			.findFirst();
	}

	public void back() {
		logic.back();
	}

	private void updateLayout() {
		if (!init) {
			return;
		}
		IRecipeCategory<?> recipeCategory = logic.getSelectedRecipeCategory();

		final int x = area.getX();
		final int y = area.getY();
		final int width = area.getWidth();
		final int height = area.getHeight();

		int availableHeight = height - headerHeight;
		final int heightPerRecipe = recipeCategory.getHeight() + innerPadding;
		int recipesPerPage = availableHeight / heightPerRecipe;

		if (recipesPerPage == 0) {
			availableHeight = heightPerRecipe;
			recipesPerPage = 1;
		}

		logic.setRecipesPerPage(recipesPerPage);

		field_22785 = StringUtil.stripStyling(recipeCategory.getTitle());
		final int availableTitleWidth = titleArea.getWidth();
		if (field_22793.method_27525(field_22785) > availableTitleWidth) {
			field_22785 = StringUtil.truncateStringToWidth(field_22785, availableTitleWidth, field_22793);
		}
		this.titleStringArea = MathUtil.centerTextArea(this.titleArea, field_22793, field_22785);

		recipeLayouts.clear();

		final int recipeXOffset = x + (width - recipeCategory.getWidth()) / 2;
		final int recipeSpacing = (availableHeight - (recipesPerPage * recipeCategory.getHeight())) / (recipesPerPage + 1);
		int spacingY = recipeCategory.getHeight() + recipeSpacing;
		int recipeYOffset = y + headerHeight + recipeSpacing;
		for (IRecipeLayoutDrawable<?> recipeLayout : logic.getRecipeLayouts()) {
			recipeLayout.setPosition(recipeXOffset, recipeYOffset);
			recipeYOffset += spacingY;
			recipeLayouts.add(recipeLayout);
		}

		addRecipeTransferButtons(recipeLayouts);

		nextPage.field_22763 = previousPage.field_22763 = logic.hasMultiplePages();
		nextRecipeCategory.field_22763 = previousRecipeCategory.field_22763 = logic.hasMultipleCategories();

		pageString = logic.getPageString();

		List<ITypedIngredient<?>> recipeCatalystIngredients = logic.getRecipeCatalysts().toList();
		recipeCatalysts.updateLayout(recipeCatalystIngredients, this.area);
		recipeGuiTabs.initLayout(this.area);
	}

	private void addRecipeTransferButtons(List<IRecipeLayoutDrawable<?>> recipeLayouts) {
		if (field_22787 == null) {
			return;
		}
		class_1657 player = field_22787.field_1724;
		if (player == null) {
			return;
		}

		for (class_364 button : this.recipeTransferButtons) {
			method_37066(button);
		}
		this.recipeTransferButtons.clear();

		class_1703 container = getParentContainer().orElse(null);

		recipeLayouts.forEach(recipeLayout ->
			{
				class_768 buttonArea = recipeLayout.getRecipeTransferButtonArea();
				IDrawable icon = textures.getRecipeTransfer();
				RecipeTransferButton button = new RecipeTransferButton(icon, recipeLayout, textures, this::method_25419);
				button.update(buttonArea, recipeTransferManager, container, player);
				method_37063(button);
				this.recipeTransferButtons.add(button);
			}
		);
	}

	private Optional<class_1703> getParentContainer() {
		if (parentScreen instanceof class_465<?> screen) {
			class_1703 menu = screen.method_17577();
			return Optional.of(menu);
		}
		return Optional.empty();
	}

	@Override
	public void onStateChange() {
		updateLayout();
	}

	@Nullable
	public IGuiProperties getProperties() {
		if (field_22789 <= 0 || field_22790 <= 0) {
			return null;
		}
		int extraWidth = getRecipeCatalystExtraWidth();
		ImmutableRect2i recipeArea = getArea();
		int guiXSize = recipeArea.getWidth() + extraWidth;
		int guiYSize = recipeArea.getHeight();
		if (guiXSize <= 0 || guiYSize <= 0) {
			return null;
		}
		return new GuiProperties(
			getClass(),
			recipeArea.getX() - extraWidth,
			recipeArea.getY(),
			guiXSize,
			guiYSize,
			field_22789,
			field_22790
		);
	}
}
