package mezz.jei.gui.overlay;

import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketRequestCheatPermission;
import mezz.jei.common.platform.IPlatformConfigHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public class ConfigButton extends GuiIconToggleButton {
	private final IInternalKeyMappings keyBindings;

	public static ConfigButton create(BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IInternalKeyMappings keyBindings) {
		return new ConfigButton(textures.getConfigButtonIcon(), textures.getConfigButtonCheatIcon(), isListDisplayed, worldConfig, textures, keyBindings);
	}

	private final BooleanSupplier isListDisplayed;
	private final IWorldConfig worldConfig;

	private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IInternalKeyMappings keyBindings) {
		super(disabledIcon, enabledIcon, textures);
		this.isListDisplayed = isListDisplayed;
		this.worldConfig = worldConfig;
		this.keyBindings = keyBindings;
	}

	@Override
	protected void getTooltips(List<class_2561> tooltip) {
		tooltip.add(class_2561.method_43471("jei.tooltip.config"));
		if (!worldConfig.isOverlayEnabled()) {
			class_5250 disabled = class_2561.method_43471("jei.tooltip.ingredient.list.disabled");
			class_5250 disabledFix = class_2561.method_43469(
				"jei.tooltip.ingredient.list.disabled.how.to.fix",
				keyBindings.getToggleOverlay().getTranslatedKeyMessage()
			);
			tooltip.add(disabled.method_27692(class_124.field_1065));
			tooltip.add(disabledFix.method_27692(class_124.field_1065));
		} else if (!isListDisplayed.getAsBoolean()) {
			class_5250 notEnoughSpace = class_2561.method_43471("jei.tooltip.not.enough.space");
			tooltip.add(notEnoughSpace.method_27692(class_124.field_1065));
		}
		if (worldConfig.isCheatItemsEnabled()) {
			class_5250 enabled = class_2561.method_43471("jei.tooltip.cheat.mode.button.enabled")
				.method_27692(class_124.field_1061);
			tooltip.add(enabled);

			if (!keyBindings.getToggleCheatMode().isUnbound()) {
				class_5250 component = class_2561.method_43469(
					"jei.tooltip.cheat.mode.how.to.disable.hotkey",
					keyBindings.getToggleCheatMode().getTranslatedKeyMessage()
				).method_27692(class_124.field_1061);
				tooltip.add(component);
			} else if (!keyBindings.getToggleCheatModeConfigButton().isUnbound()) {
				class_5250 component = class_2561.method_43469(
					"jei.tooltip.cheat.mode.how.to.disable.hover.config.button.hotkey",
					keyBindings.getToggleCheatModeConfigButton().getTranslatedKeyMessage()
				).method_27692(class_124.field_1061);
				tooltip.add(component);
			}
		}
	}

	@Override
	protected boolean isIconToggledOn() {
		return worldConfig.isCheatItemsEnabled();
	}

	@Override
	protected boolean onMouseClicked(UserInput input) {
		if (worldConfig.isOverlayEnabled()) {
			if (!input.isSimulate()) {
				if (input.is(keyBindings.getToggleCheatModeConfigButton())) {
					worldConfig.toggleCheatItemsEnabled();
					if (worldConfig.isCheatItemsEnabled()) {
						IConnectionToServer serverConnection = Internal.getServerConnection();
						serverConnection.sendPacketToServer(new PacketRequestCheatPermission());
					}
				} else {
					openSettings();
				}
			}
			return true;
		}
		return false;
	}

	private static void openSettings() {
		class_310 mc = class_310.method_1551();
		if (mc.field_1724 == null) {
			return;
		}

		IPlatformConfigHelper configHelper = Services.PLATFORM.getConfigHelper();
		Optional<class_437> configScreen = configHelper.getConfigScreen();

		if (configScreen.isPresent()) {
			mc.method_1507(configScreen.get());
		} else {
			class_2561 message = configHelper.getMissingConfigScreenMessage();
			mc.field_1724.method_7353(message, false);
		}
	}
}
