package mezz.jei.gui.input.handlers;

import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.gui.overlay.IIngredientGrid;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketDeletePlayerItem;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.gui.util.CheatUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import mezz.jei.common.util.ServerCommandUtil;
import mezz.jei.core.config.GiveMode;
import mezz.jei.gui.config.IClientConfig;
import mezz.jei.core.config.IWorldConfig;
import java.util.List;
import java.util.Optional;

public class DeleteItemInputHandler implements IUserInputHandler {
	private final IIngredientGrid ingredientGrid;
	private final IWorldConfig worldConfig;
	private final IClientConfig clientConfig;
	private final IConnectionToServer serverConnection;
	private final CheatUtil cheatUtil;

	public DeleteItemInputHandler(
		IIngredientGrid ingredientGrid,
		IWorldConfig worldConfig,
		IClientConfig clientConfig,
		IConnectionToServer serverConnection,
		CheatUtil cheatUtil
	) {
		this.ingredientGrid = ingredientGrid;
		this.worldConfig = worldConfig;
		this.clientConfig = clientConfig;
		this.serverConnection = serverConnection;
		this.cheatUtil = cheatUtil;
	}

	@Override
	public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput userInput, IInternalKeyMappings keyBindings) {
		if (!userInput.is(keyBindings.getLeftClick())) {
			return Optional.empty();
		}
		double mouseX = userInput.getMouseX();
		double mouseY = userInput.getMouseY();
		if (!this.ingredientGrid.isMouseOver(mouseX, mouseY)) {
			return Optional.empty();
		}
		class_310 minecraft = class_310.method_1551();
		if (!shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
			return Optional.empty();
		}
		class_746 player = minecraft.field_1724;
		if (player == null) {
			return Optional.empty();
		}
		class_1799 itemStack = player.field_7512.method_34255();
		if (itemStack.method_7960()) {
			return Optional.empty();
		}
		if (!userInput.isSimulate()) {
			player.field_7512.method_34254(class_1799.field_8037);
			PacketJei packet = new PacketDeletePlayerItem(itemStack);
			serverConnection.sendPacketToServer(packet);
		}
		return Optional.of(this);
	}

	@SuppressWarnings("MethodMayBeStatic")
	public void drawTooltips(class_4587 poseStack, int mouseX, int mouseY) {
		class_2561 deleteItem = class_2561.method_43471("jei.tooltip.delete.item");
		TooltipRenderer.drawHoveringText(poseStack, List.of(deleteItem), mouseX, mouseY);
	}

	public boolean shouldDeleteItemOnClick(class_310 minecraft, double mouseX, double mouseY) {
		if (!worldConfig.isCheatItemsEnabled() || !serverConnection.isJeiOnServer()) {
			return false;
		}
		class_1657 player = minecraft.field_1724;
		if (player == null) {
			return false;
		}
		class_1799 itemStack = player.field_7512.method_34255();
		if (itemStack.method_7960()) {
			return false;
		}
		GiveMode giveMode = this.clientConfig.getGiveMode();
		if (giveMode == GiveMode.MOUSE_PICKUP) {
			return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY)
				.findFirst()
				.map(cheatUtil::getCheatItemStack)
				.map(i -> !ServerCommandUtil.canStack(itemStack, i))
				.orElse(true);
		}
		return true;
	}
}
