package mezz.jei.gui.events;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.RectDebugger;
import mezz.jei.core.util.LimitedLogger;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class GuiEventHandler {
	private static final Logger LOGGER = LogManager.getLogger();
	private static final LimitedLogger missingBackgroundLogger = new LimitedLogger(LOGGER, Duration.ofHours(1));

	private final IngredientListOverlay ingredientListOverlay;
	private final IScreenHelper screenHelper;
	private final BookmarkOverlay bookmarkOverlay;
	private boolean drawnOnBackground = false;

	public GuiEventHandler(
		IScreenHelper screenHelper,
		BookmarkOverlay bookmarkOverlay,
		IngredientListOverlay ingredientListOverlay
	) {
		this.screenHelper = screenHelper;
		this.bookmarkOverlay = bookmarkOverlay;
		this.ingredientListOverlay = ingredientListOverlay;
	}

	public void onGuiInit(class_437 screen) {
		Set<ImmutableRect2i> guiExclusionAreas = screenHelper.getGuiExclusionAreas(screen)
			.map(ImmutableRect2i::new)
			.collect(Collectors.toUnmodifiableSet());
		ingredientListOverlay.updateScreen(screen, guiExclusionAreas);
		bookmarkOverlay.updateScreen(screen, guiExclusionAreas);
	}

	public void onGuiOpen(class_437 screen) {
		ingredientListOverlay.updateScreen(screen, null);
		bookmarkOverlay.updateScreen(screen, null);
	}

	public void onDrawBackgroundPost(class_437 screen, class_4587 poseStack) {
		class_310 minecraft = class_310.method_1551();
		Set<ImmutableRect2i> guiExclusionAreas = screenHelper.getGuiExclusionAreas(screen)
			.map(ImmutableRect2i::new)
			.collect(Collectors.toUnmodifiableSet());
		ingredientListOverlay.updateScreen(screen, guiExclusionAreas);
		bookmarkOverlay.updateScreen(screen, guiExclusionAreas);

		drawnOnBackground = true;
		double mouseX = MouseUtil.getX();
		double mouseY = MouseUtil.getY();
		ingredientListOverlay.drawScreen(minecraft, poseStack, (int) mouseX, (int) mouseY, minecraft.method_1488());
		bookmarkOverlay.drawScreen(minecraft, poseStack, (int) mouseX, (int) mouseY, minecraft.method_1488());
	}

	/**
	 * Draws above most ContainerScreen elements, but below the tooltips.
	 */
	public void onDrawForeground(class_465<?> screen, class_4587 poseStack, int mouseX, int mouseY) {
		class_310 minecraft = class_310.method_1551();
		ingredientListOverlay.drawOnForeground(minecraft, poseStack, screen, mouseX, mouseY);
	}

	public void onDrawScreenPost(class_437 screen, class_4587 poseStack, int mouseX, int mouseY) {
		class_310 minecraft = class_310.method_1551();

		ingredientListOverlay.updateScreen(screen, null);
		bookmarkOverlay.updateScreen(screen, null);

		if (!drawnOnBackground) {
			if (screen instanceof class_465) {
				String guiName = screen.getClass().getName();
				missingBackgroundLogger.log(Level.WARN, guiName, "GUI did not draw the dark background layer behind itself, this may result in display issues: {}", guiName);
			}
			ingredientListOverlay.drawScreen(minecraft, poseStack, mouseX, mouseY, minecraft.method_1488());
			bookmarkOverlay.drawScreen(minecraft, poseStack, mouseX, mouseY, minecraft.method_1488());
		}
		drawnOnBackground = false;

		if (screen instanceof class_465<?> guiContainer) {
			IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
			int guiLeft = screenHelper.getGuiLeft(guiContainer);
			int guiTop = screenHelper.getGuiTop(guiContainer);
			this.screenHelper.getGuiClickableArea(guiContainer, mouseX - guiLeft, mouseY - guiTop)
				.filter(IGuiClickableArea::isTooltipEnabled)
				.map(IGuiClickableArea::getTooltipStrings)
				.findFirst()
				.ifPresent(tooltipStrings -> {
					if (tooltipStrings.isEmpty()) {
						tooltipStrings = List.of(class_2561.method_43471("jei.tooltip.show.recipes"));
					}
					TooltipRenderer.drawHoveringText(poseStack, tooltipStrings, mouseX, mouseY);
				});
		}

		ingredientListOverlay.drawTooltips(minecraft, poseStack, mouseX, mouseY);
		bookmarkOverlay.drawTooltips(minecraft, poseStack, mouseX, mouseY);

		if (DebugConfig.isDebugModeEnabled()) {
			drawDebugInfoForScreen(screen, poseStack);
		}
	}

	public void onClientTick() {
		ingredientListOverlay.handleTick();
	}

	public boolean renderCompactPotionIndicators() {
		return ingredientListOverlay.isListDisplayed();
	}

	private void drawDebugInfoForScreen(class_437 screen, class_4587 poseStack) {
		RectDebugger.INSTANCE.draw(poseStack);

		screenHelper.getGuiProperties(screen)
			.ifPresent(guiProperties -> {
				Set<class_768> guiExclusionAreas = screenHelper.getGuiExclusionAreas(screen)
					.collect(Collectors.toUnmodifiableSet());

				RenderSystem.disableDepthTest();

				// draw the gui exclusion areas
				for (class_768 area : guiExclusionAreas) {
					class_332.method_25294(
						poseStack,
						area.method_3321(),
						area.method_3322(),
						area.method_3321() + area.method_3319(),
						area.method_3322() + area.method_3320(),
						0x44FF0000
					);
				}

				// draw the gui area
				class_332.method_25294(
					poseStack,
					guiProperties.getGuiLeft(),
					guiProperties.getGuiTop(),
					guiProperties.getGuiLeft() + guiProperties.getGuiXSize(),
					guiProperties.getGuiTop() + guiProperties.getGuiYSize(),
					0x22CCCC00
				);

				RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
			});
	}
}
