package mezz.jei.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

/**
 * A small gui button that has an {@link IDrawable} instead of a string label.
 */
public class GuiIconButtonSmall extends class_4185 {
	private final IDrawable icon;
	private final Textures textures;

	public GuiIconButtonSmall(int x, int y, int widthIn, int heightIn, IDrawable icon, class_4185.class_4241 pressable, Textures textures) {
		super(x, y, widthIn, heightIn, class_5244.field_39003, pressable);
		this.icon = icon;
		this.textures = textures;
	}

	public ImmutableRect2i getArea() {
		return new ImmutableRect2i(field_22760, field_22761, field_22758, field_22759);
	}

	@Override
	public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
		if (this.field_22764) {
			class_310 minecraft = class_310.method_1551();
			RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
			boolean hovered = method_25405(mouseX, mouseY);
			DrawableNineSliceTexture texture = textures.getButtonForState(this.field_22763, hovered);
			texture.draw(poseStack, this.field_22760, this.field_22761, this.field_22758, this.field_22759);
			this.method_25353(poseStack, minecraft, mouseX, mouseY);

			int color = 0xFFE0E0E0;
			if (!this.field_22763) {
				color = 0xFFA0A0A0;
			} else if (hovered) {
				color = 0xFFFFFFFF;
			}

			float red = (color >> 16 & 255) / 255.0F;
			float blue = (color >> 8 & 255) / 255.0F;
			float green = (color & 255) / 255.0F;
			float alpha = (color >> 24 & 255) / 255.0F;
			RenderSystem.setShaderColor(red, blue, green, alpha);

			double xOffset = field_22760 + (field_22758 - this.icon.getWidth()) / 2.0;
			double yOffset = field_22761 + (field_22759 - this.icon.getHeight()) / 2.0;
			poseStack.method_22903();
			{
				poseStack.method_22904(xOffset, yOffset, 0);
				this.icon.draw(poseStack);
			}
			poseStack.method_22909();
		}
	}
}
