package mezz.jei.gui.elements;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import mezz.jei.common.util.ImmutableRect2i;
import java.util.Optional;

/**
 * A gui button that has an {@link IDrawable} instead of a string label.
 */
public class GuiIconButton extends class_4185 {
	private final IDrawable icon;
	private final Textures textures;

	public GuiIconButton(IDrawable icon, class_4241 pressable, Textures textures) {
		super(0, 0, 0, 0, class_5244.field_39003, pressable);
		this.icon = icon;
		this.textures = textures;
	}

	public void updateBounds(ImmutableRect2i area) {
		this.field_22760 = area.getX();
		this.field_22761 = area.getY();
		this.field_22758 = area.getWidth();
		this.field_22759 = area.getHeight();
	}

	public void setHeight(int value) {
		this.field_22759 = value;
	}

	@Override
	public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
		if (this.field_22764) {
			RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
			boolean hovered = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759;
			RenderSystem.enableBlend();
			RenderSystem.blendFuncSeparate(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, GlStateManager.class_4535.ONE, GlStateManager.class_4534.ZERO);
			RenderSystem.blendFunc(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
			class_310 minecraft = class_310.method_1551();
			DrawableNineSliceTexture texture = textures.getButtonForState(this.field_22763, hovered);
			texture.draw(poseStack, this.field_22760, this.field_22761, this.field_22758, this.field_22759);
			this.method_25353(poseStack, minecraft, mouseX, mouseY);
			int color = 0xFFE0E0E0;
			if (!this.field_22763) {
				color = 0xFFA0A0A0;
			} else if (hovered) {
				color = 0xFFFFFFFF;
			}

			float red = (color >> 16 & 255) / 255.0F;
			float blue = (color >> 8 & 255) / 255.0F;
			float green = (color & 255) / 255.0F;
			float alpha = (color >> 24 & 255) / 255.0F;
			RenderSystem.setShaderColor(red, blue, green, alpha);

			double xOffset = field_22760 + (field_22758 - icon.getWidth()) / 2.0;
			double yOffset = field_22761 + (field_22759 - icon.getHeight()) / 2.0;
			poseStack.method_22903();
			{
				poseStack.method_22904(xOffset, yOffset, 0);
				icon.draw(poseStack);
			}
			poseStack.method_22909();
			RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
		}
	}

	public IUserInputHandler createInputHandler() {
		return new UserInputHandler(this);
	}

	private class UserInputHandler implements IUserInputHandler {
		private final GuiIconButton button;

		public UserInputHandler(GuiIconButton button) {
			this.button = button;
		}

		@Override
		public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
			if (!input.isMouse()) {
				return Optional.empty();
			}
			double mouseX = input.getMouseX();
			double mouseY = input.getMouseY();
			if (!this.button.field_22763 || !this.button.field_22764 || !method_25405(mouseX, mouseY)) {
				return Optional.empty();
			}
			if (!this.button.method_25351(input.getKey().method_1444())) {
				return Optional.empty();
			}
			boolean flag = this.button.method_25361(mouseX, mouseY);
			if (!flag) {
				return Optional.empty();
			}
			if (!input.isSimulate()) {
				this.button.method_25354(class_310.method_1551().method_1483());
				this.button.method_25348(mouseX, mouseY);
			}
			return Optional.of(this);
		}
	}
}
