package mezz.jei.fabric.mixin;

import mezz.jei.fabric.events.JeiLifecycleEvents;
import net.minecraft.class_1060;
import net.minecraft.class_310;
import net.minecraft.class_3304;
import net.minecraft.class_542;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_310.class)
public class MinecraftMixin {
    @Shadow
    @Final
    private class_3304 resourceManager;

    @Shadow
    @Final
    private class_1060 textureManager;

    @Inject(
        method = "<init>(Lnet/minecraft/client/main/GameConfig;)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/ResourceLoadStateTracker;startReload(Lnet/minecraft/client/ResourceLoadStateTracker$ReloadReason;Ljava/util/List;)V",
            shift = At.Shift.BEFORE
        )
    )
    public void beforeInitialResourceReload(class_542 gameConfig, CallbackInfo ci) {
        JeiLifecycleEvents.REGISTER_RESOURCE_RELOAD_LISTENER.invoker()
                .registerResourceReloadListener(resourceManager, textureManager);
    }
}
