package mezz.jei.common.util;

import mezz.jei.core.util.PathUtil;
import mezz.jei.core.util.ReflectionUtil;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_32;
import java.nio.file.Path;
import java.util.Optional;

public final class ServerConfigPathUtil {
	private static final Path worldDirPath = Path.of("world");
	private static final ReflectionUtil reflectionUtil = new ReflectionUtil();

	private ServerConfigPathUtil() {

	}

	public static Optional<Path> getWorldPath(Path basePath) {
		return getWorldPath()
			.map(basePath::resolve);
	}

	private static Optional<Path> getWorldPath() {
		class_310 minecraft = class_310.method_1551();
		return Optional.ofNullable(minecraft.method_1562())
			.flatMap(clientPacketListener -> {
				class_2535 connection = clientPacketListener.method_2872();
				if (connection.method_10756()) {
					return Optional.ofNullable(minecraft.method_1576())
						.flatMap(minecraftServer ->
							reflectionUtil.getFieldWithClass(minecraftServer, class_32.class_5143.class)
								.findFirst()
								.map(class_32.class_5143::method_27005)
								.map(PathUtil::sanitizePathName)
								.map(name -> worldDirPath.resolve("local").resolve(name))
						);
				}
				return Optional.ofNullable(minecraft.method_1558())
					.map(serverData -> {
						int ipHash = serverData.field_3761.hashCode();
						String ipHashHex = Integer.toHexString(ipHash);
						String name = String.format("%s_%s", serverData.field_3752, ipHashHex);
						name = PathUtil.sanitizePathName(name);
						return worldDirPath.resolve("server").resolve(name);
					});
			});
	}
}
