package mezz.jei.api.helpers;

import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

/**
 * Helper for mods that want to handle Fluid ingredients across multiple platforms (Forge and Fabric).
 * @param <T> the type of Fluid ingredient for the current platform.
 * @since 10.1.0
 */
public interface IPlatformFluidHelper<T> {
    /**
     * Returns the type of Fluid ingredients on the current platform.
     * @since 10.1.0
     */
    IIngredientTypeWithSubtypes<class_3611, T> getFluidIngredientType();

    /**
     * Creates a new fluid ingredient for the current platform.
     * @since 10.1.0
     */
    T create(class_3611 fluid, long amount, @Nullable class_2487 tag);

    /**
     * Creates a new fluid ingredient for the current platform.
     * @since 10.1.0
     */
    T create(class_3611 fluid, long amount);

    /**
     * Returns amount of Fluid in one bucket on the current platform.
     * @since 10.1.0
     */
    long bucketVolume();
}
