package mezz.jei.api.gui.ingredient;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_768;

/**
 * A drawable recipe slot, useful if you need to make JEI draw a slot somewhere.
 *
 * @since 11.5.0
 */
public interface IRecipeSlotDrawable extends IRecipeSlotView {
	/**
	 * Get the position and size of the recipe slot drawable relative to its parent element.
	 *
	 * @since 11.5.0
	 */
	class_768 getRect();

	/**
	 * Draws the recipe slot relative to the pose stack.
	 *
	 * @since 11.5.0
	 */
	void draw(class_4587 poseStack);

	/**
	 * Draws the recipe slot overlays, called when the mouse is hovering over this recipe slot.
	 *
	 * @since 11.5.0
	 */
	void drawHoverOverlays(class_4587 poseStack);

	/**
	 * Get the tooltip for this recipe slot.
	 *
	 * @since 11.5.0
	 */
	List<class_2561> getTooltip();

	/**
	 * Add a tooltip callback to be called when the mouse is hovering over this recipe slot.
	 *
	 * @since 11.5.0
	 */
	void addTooltipCallback(IRecipeSlotTooltipCallback tooltipCallback);
}
