/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.ingredients;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.IngredientTooltipHelper;
import mezz.jei.library.gui.ingredients.CycleTimer;
import mezz.jei.library.gui.ingredients.RendererOverrides;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeSlot
extends class_332
implements IRecipeSlotView,
IRecipeSlotDrawable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_DISPLAYED_INGREDIENTS = 100;
    private final IIngredientManager ingredientManager;
    private final RecipeIngredientRole role;
    private final CycleTimer cycleTimer;
    private final List<IRecipeSlotTooltipCallback> tooltipCallbacks = new ArrayList<IRecipeSlotTooltipCallback>();
    private final RendererOverrides rendererOverrides;
    private @Unmodifiable List<Optional<ITypedIngredient<?>>> displayIngredients = List.of();
    private @Unmodifiable List<Optional<ITypedIngredient<?>>> allIngredients = List.of();
    private ImmutableRect2i rect;
    @Nullable
    private IDrawable background;
    @Nullable
    private IDrawable overlay;
    @Nullable
    private String slotName;

    public RecipeSlot(IIngredientManager ingredientManager, RecipeIngredientRole role, int xPos, int yPos, int ingredientCycleOffset) {
        this.ingredientManager = ingredientManager;
        this.rendererOverrides = new RendererOverrides();
        this.role = role;
        this.rect = new ImmutableRect2i(xPos, yPos, 16, 16);
        this.cycleTimer = new CycleTimer(ingredientCycleOffset);
    }

    @Override
    public @Unmodifiable Stream<ITypedIngredient<?>> getAllIngredients() {
        return this.allIngredients.stream().flatMap(Optional::stream);
    }

    @Override
    public boolean isEmpty() {
        return this.getAllIngredients().findAny().isEmpty();
    }

    @Override
    public <T> Stream<T> getIngredients(IIngredientType<T> ingredientType) {
        return this.getAllIngredients().map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream);
    }

    @Override
    public Optional<ITypedIngredient<?>> getDisplayedIngredient() {
        return this.cycleTimer.getCycledItem(this.displayIngredients);
    }

    @Override
    public <T> Optional<T> getDisplayedIngredient(IIngredientType<T> ingredientType) {
        return this.getDisplayedIngredient().flatMap(i -> i.getIngredient(ingredientType));
    }

    @Override
    public Optional<String> getSlotName() {
        return Optional.ofNullable(this.slotName);
    }

    @Override
    public RecipeIngredientRole getRole() {
        return this.role;
    }

    @Override
    public void drawHighlight(class_4587 poseStack, int color) {
        int x = this.rect.getX();
        int y = this.rect.getY();
        int width = this.rect.getWidth();
        int height = this.rect.getHeight();
        RenderSystem.disableDepthTest();
        RecipeSlot.method_25294((class_4587)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private <T> List<class_2561> getTooltip(ITypedIngredient<T> typedIngredient) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        T value = typedIngredient.getIngredient();
        try {
            IIngredientRenderer<T> ingredientRenderer = this.getIngredientRenderer(ingredientType);
            return this.getTooltip(value, ingredientType, ingredientRenderer);
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception when rendering tooltip on {}.", value, (Object)e);
            return List.of();
        }
    }

    private <T> List<class_2561> getTooltip(T value, IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer) {
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
        List<class_2561> tooltip = IngredientTooltipHelper.getMutableIngredientTooltipSafe(value, ingredientRenderer);
        for (IRecipeSlotTooltipCallback tooltipCallback : this.tooltipCallbacks) {
            tooltipCallback.onTooltip(this, tooltip);
        }
        List<T> ingredients = this.getIngredients(ingredientType).toList();
        ingredientHelper.getTagEquivalent(ingredients).ifPresent(tagEquivalent -> {
            class_5250 acceptsAny = class_2561.method_43469((String)"jei.tooltip.recipe.tag", (Object[])new Object[]{tagEquivalent});
            tooltip.add((class_2561)acceptsAny.method_27692(class_124.field_1080));
        });
        return tooltip;
    }

    public void setBackground(IDrawable background) {
        this.background = background;
    }

    public void setOverlay(IDrawable overlay) {
        this.overlay = overlay;
    }

    public void set(List<Optional<ITypedIngredient<?>>> ingredients, Set<Integer> focusMatches, IIngredientVisibility ingredientVisibility) {
        this.allIngredients = List.copyOf(ingredients);
        if (!focusMatches.isEmpty()) {
            this.displayIngredients = focusMatches.stream().filter(i -> i < this.allIngredients.size()).map(i -> this.allIngredients.get((int)i)).toList();
        } else {
            this.displayIngredients = this.allIngredients.stream().filter(i -> i.isEmpty() || ingredientVisibility.isIngredientVisible((ITypedIngredient)i.get())).limit(100L).toList();
            if (this.displayIngredients.isEmpty()) {
                this.displayIngredients = this.allIngredients.stream().limit(100L).toList();
            }
        }
    }

    @Override
    public void addTooltipCallback(IRecipeSlotTooltipCallback tooltipCallback) {
        this.tooltipCallbacks.add(tooltipCallback);
    }

    public <T> void addRenderOverride(IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer) {
        this.rendererOverrides.addOverride(ingredientType, ingredientRenderer);
        this.rect = new ImmutableRect2i(this.rect.getX(), this.rect.getY(), this.rendererOverrides.getIngredientWidth(), this.rendererOverrides.getIngredientHeight());
    }

    private <T> IIngredientRenderer<T> getIngredientRenderer(IIngredientType<T> ingredientType) {
        return Optional.of(this.rendererOverrides).flatMap(r -> r.getIngredientRenderer(ingredientType)).orElseGet(() -> this.ingredientManager.getIngredientRenderer(ingredientType));
    }

    @Override
    public void draw(class_4587 poseStack) {
        this.cycleTimer.onDraw();
        int x = this.rect.getX();
        int y = this.rect.getY();
        poseStack.method_22903();
        poseStack.method_22904((double)x, (double)y, 0.0);
        if (this.background != null) {
            this.background.draw(poseStack);
        }
        RenderSystem.enableBlend();
        this.getDisplayedIngredient().ifPresent(ingredient -> this.drawIngredient(poseStack, (ITypedIngredient)ingredient));
        if (this.overlay != null) {
            RenderSystem.enableBlend();
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.0, 200.0);
            this.overlay.draw(poseStack);
            poseStack.method_22909();
        }
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    private <T> void drawIngredient(class_4587 poseStack, ITypedIngredient<T> typedIngredient) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        T ingredient = typedIngredient.getIngredient();
        IIngredientRenderer<T> ingredientRenderer = this.getIngredientRenderer(ingredientType);
        try {
            ingredientRenderer.render(poseStack, ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, ingredient, this.ingredientManager);
        }
    }

    @Override
    public void drawHoverOverlays(class_4587 poseStack) {
        this.drawHighlight(poseStack, -2130706433);
    }

    @Override
    public List<class_2561> getTooltip() {
        return this.getDisplayedIngredient().map(this::getTooltip).orElseGet(List::of);
    }

    @Override
    public class_768 getRect() {
        return this.rect.toMutable();
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }
}

