/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.List;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.recipes.IOnClickHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButton
extends GuiIconButtonSmall {
    private final IRecipeLayoutDrawable<?> recipeLayout;
    private final Runnable onClose;
    @Nullable
    private IRecipeTransferError recipeTransferError;
    @Nullable
    private IOnClickHandler onClickHandler;

    public RecipeTransferButton(IDrawable icon, IRecipeLayoutDrawable<?> recipeLayout, Textures textures, Runnable onClose) {
        super(0, 0, 0, 0, icon, b -> {}, textures);
        this.recipeLayout = recipeLayout;
        this.onClose = onClose;
    }

    public void update(class_768 area, IRecipeTransferManager recipeTransferManager, @Nullable class_1703 container, class_1657 player) {
        this.field_22760 = area.method_3321();
        this.field_22761 = area.method_3322();
        this.field_22758 = area.method_3319();
        this.field_22759 = area.method_3320();
        this.recipeTransferError = container != null ? (IRecipeTransferError)RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, this.recipeLayout, player).orElse(null) : RecipeTransferErrorInternal.INSTANCE;
        if (this.recipeTransferError == null || this.recipeTransferError.getType().allowsTransfer) {
            this.field_22763 = true;
            this.field_22764 = true;
        } else {
            this.field_22763 = false;
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            this.field_22764 = type == IRecipeTransferError.Type.USER_FACING;
        }
        this.onClickHandler = (mouseX, mouseY) -> {
            boolean maxTransfer = class_437.method_25442();
            if (container != null && RecipeTransferUtil.transferRecipe(recipeTransferManager, container, this.recipeLayout, player, maxTransfer)) {
                this.onClose.run();
            }
        };
    }

    public void drawToolTip(class_4587 poseStack, int mouseX, int mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            if (this.recipeTransferError == null) {
                class_5250 tooltipTransfer = class_2561.method_43471((String)"jei.tooltip.transfer");
                TooltipRenderer.drawHoveringText(poseStack, List.of(tooltipTransfer), mouseX, mouseY);
            } else {
                IRecipeSlotsView recipeSlotsView = this.recipeLayout.getRecipeSlotsView();
                class_768 recipeRect = this.recipeLayout.getRect();
                this.recipeTransferError.showError(poseStack, mouseX, mouseY, recipeSlotsView, recipeRect.method_3321(), recipeRect.method_3322());
            }
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && mouseX >= (double)this.field_22760 && mouseY >= (double)this.field_22761 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY < (double)(this.field_22761 + this.field_22759);
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        if (this.field_22764 && this.recipeTransferError != null && this.recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
            RecipeTransferButton.method_25294((class_4587)poseStack, (int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759), (int)this.recipeTransferError.getButtonHighlightColor());
        }
    }

    public void method_25357(double mouseX, double mouseY) {
        if (!this.method_25405(mouseX, mouseY)) {
            return;
        }
        if (this.onClickHandler != null) {
            this.onClickHandler.onClick(mouseX, mouseY);
        }
    }
}

