/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IClickableIngredientInternal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.config.IClientConfig;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.input.handlers.CheatInputHandler;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.input.handlers.ProxyInputHandler;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.overlay.ScreenPropertiesCache;
import mezz.jei.gui.overlay.bookmarks.BookmarkButton;
import mezz.jei.gui.util.CheatUtil;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class BookmarkOverlay
implements IRecipeFocusSource,
IBookmarkOverlay {
    private static final int BORDER_MARGIN = 6;
    private static final int INNER_PADDING = 2;
    private static final int BUTTON_SIZE = 20;
    private final CheatInputHandler cheatInputHandler;
    private final ScreenPropertiesCache screenPropertiesCache;
    private final IngredientGridWithNavigation contents;
    private final GuiIconToggleButton bookmarkButton;
    private final BookmarkList bookmarkList;
    private final IWorldConfig worldConfig;

    public BookmarkOverlay(BookmarkList bookmarkList, Textures textures, IngredientGridWithNavigation contents, IClientConfig clientConfig, IWorldConfig worldConfig, IScreenHelper screenHelper, IConnectionToServer serverConnection, IInternalKeyMappings keyBindings, CheatUtil cheatUtil) {
        this.bookmarkList = bookmarkList;
        this.worldConfig = worldConfig;
        this.bookmarkButton = BookmarkButton.create(this, bookmarkList, textures, worldConfig, keyBindings);
        this.cheatInputHandler = new CheatInputHandler(this, worldConfig, clientConfig, serverConnection, cheatUtil);
        this.contents = contents;
        this.screenPropertiesCache = new ScreenPropertiesCache(screenHelper);
        bookmarkList.addSourceListChangedListener(() -> {
            worldConfig.setBookmarkEnabled(!bookmarkList.isEmpty());
            class_310 minecraft = class_310.method_1551();
            class_437 screen = minecraft.field_1755;
            this.updateScreen(screen, null);
        });
    }

    public boolean isListDisplayed() {
        return this.worldConfig.isBookmarkOverlayEnabled() && this.screenPropertiesCache.hasValidScreen() && this.contents.hasRoom() && !this.bookmarkList.isEmpty();
    }

    public boolean hasRoom() {
        return this.contents.hasRoom();
    }

    public void updateScreen(@Nullable class_437 guiScreen, @Nullable Set<ImmutableRect2i> updatedGuiExclusionAreas) {
        this.screenPropertiesCache.updateScreen(guiScreen, updatedGuiExclusionAreas, this::onScreenPropertiesChanged);
    }

    private void onScreenPropertiesChanged() {
        this.screenPropertiesCache.getGuiProperties().ifPresent(guiProperties -> {
            Set<ImmutableRect2i> guiExclusionAreas = this.screenPropertiesCache.getGuiExclusionAreas();
            this.updateBounds((IGuiProperties)guiProperties, guiExclusionAreas);
        });
    }

    private void updateBounds(IGuiProperties guiProperties, Set<ImmutableRect2i> guiExclusionAreas) {
        ImmutableRect2i displayArea = new ImmutableRect2i(0, 0, guiProperties.getGuiLeft(), guiProperties.getScreenHeight());
        ImmutableRect2i availableContentsArea = displayArea.cropBottom(22);
        this.contents.updateBounds(availableContentsArea, guiExclusionAreas);
        this.contents.updateLayout(false);
        if (this.contents.hasRoom()) {
            ImmutableRect2i contentsArea = this.contents.getBackgroundArea();
            ImmutableRect2i bookmarkButtonArea = displayArea.insetBy(6).matchWidthAndX(contentsArea).keepBottom(20).keepLeft(20);
            this.bookmarkButton.updateBounds(bookmarkButtonArea);
        } else {
            ImmutableRect2i bookmarkButtonArea = displayArea.insetBy(6).keepBottom(20).keepLeft(20);
            this.bookmarkButton.updateBounds(bookmarkButtonArea);
        }
    }

    public void drawScreen(class_310 minecraft, class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            this.contents.draw(minecraft, poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.screenPropertiesCache.hasValidScreen()) {
            this.bookmarkButton.draw(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public void drawTooltips(class_310 minecraft, class_4587 poseStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.contents.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        }
        if (this.screenPropertiesCache.hasValidScreen()) {
            this.bookmarkButton.drawTooltips(poseStack, mouseX, mouseY);
        }
    }

    @Override
    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return Stream.empty();
    }

    @Override
    public Optional<ITypedIngredient<?>> getIngredientUnderMouse() {
        double mouseX = MouseUtil.getX();
        double mouseY = MouseUtil.getY();
        return this.getIngredientUnderMouse(mouseX, mouseY).map(IClickableIngredientInternal::getTypedIngredient).findFirst();
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        double mouseX = MouseUtil.getX();
        double mouseY = MouseUtil.getY();
        return this.getIngredientUnderMouse(mouseX, mouseY).map(IClickableIngredientInternal::getTypedIngredient).map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream).findFirst().orElse(null);
    }

    public IUserInputHandler createInputHandler() {
        IUserInputHandler bookmarkButtonInputHandler = this.bookmarkButton.createInputHandler();
        CombinedInputHandler displayedInputHandler = new CombinedInputHandler(this.cheatInputHandler, this.contents.createInputHandler(), bookmarkButtonInputHandler);
        return new ProxyInputHandler(() -> {
            if (this.isListDisplayed()) {
                return displayedInputHandler;
            }
            return bookmarkButtonInputHandler;
        });
    }
}

