/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketRequestCheatPermission;
import mezz.jei.common.platform.IPlatformConfigHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ConfigButton
extends GuiIconToggleButton {
    private final IInternalKeyMappings keyBindings;
    private final BooleanSupplier isListDisplayed;
    private final IWorldConfig worldConfig;

    public static ConfigButton create(BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IInternalKeyMappings keyBindings) {
        return new ConfigButton(textures.getConfigButtonIcon(), textures.getConfigButtonCheatIcon(), isListDisplayed, worldConfig, textures, keyBindings);
    }

    private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IInternalKeyMappings keyBindings) {
        super(disabledIcon, enabledIcon, textures);
        this.isListDisplayed = isListDisplayed;
        this.worldConfig = worldConfig;
        this.keyBindings = keyBindings;
    }

    @Override
    protected void getTooltips(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43471((String)"jei.tooltip.config"));
        if (!this.worldConfig.isOverlayEnabled()) {
            class_5250 disabled = class_2561.method_43471((String)"jei.tooltip.ingredient.list.disabled");
            class_5250 disabledFix = class_2561.method_43469((String)"jei.tooltip.ingredient.list.disabled.how.to.fix", (Object[])new Object[]{this.keyBindings.getToggleOverlay().getTranslatedKeyMessage()});
            tooltip.add((class_2561)disabled.method_27692(class_124.field_1065));
            tooltip.add((class_2561)disabledFix.method_27692(class_124.field_1065));
        } else if (!this.isListDisplayed.getAsBoolean()) {
            class_5250 notEnoughSpace = class_2561.method_43471((String)"jei.tooltip.not.enough.space");
            tooltip.add((class_2561)notEnoughSpace.method_27692(class_124.field_1065));
        }
        if (this.worldConfig.isCheatItemsEnabled()) {
            class_5250 enabled = class_2561.method_43471((String)"jei.tooltip.cheat.mode.button.enabled").method_27692(class_124.field_1061);
            tooltip.add((class_2561)enabled);
            if (!this.keyBindings.getToggleCheatMode().isUnbound()) {
                component = class_2561.method_43469((String)"jei.tooltip.cheat.mode.how.to.disable.hotkey", (Object[])new Object[]{this.keyBindings.getToggleCheatMode().getTranslatedKeyMessage()}).method_27692(class_124.field_1061);
                tooltip.add((class_2561)component);
            } else if (!this.keyBindings.getToggleCheatModeConfigButton().isUnbound()) {
                component = class_2561.method_43469((String)"jei.tooltip.cheat.mode.how.to.disable.hover.config.button.hotkey", (Object[])new Object[]{this.keyBindings.getToggleCheatModeConfigButton().getTranslatedKeyMessage()}).method_27692(class_124.field_1061);
                tooltip.add((class_2561)component);
            }
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.worldConfig.isCheatItemsEnabled();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (this.worldConfig.isOverlayEnabled()) {
            if (!input.isSimulate()) {
                if (input.is(this.keyBindings.getToggleCheatModeConfigButton())) {
                    this.worldConfig.toggleCheatItemsEnabled();
                    if (this.worldConfig.isCheatItemsEnabled()) {
                        IConnectionToServer serverConnection = Internal.getServerConnection();
                        serverConnection.sendPacketToServer(new PacketRequestCheatPermission());
                    }
                } else {
                    ConfigButton.openSettings();
                }
            }
            return true;
        }
        return false;
    }

    private static void openSettings() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        IPlatformConfigHelper configHelper = Services.PLATFORM.getConfigHelper();
        Optional<class_437> configScreen = configHelper.getConfigScreen();
        if (configScreen.isPresent()) {
            mc.method_1507(configScreen.get());
        } else {
            class_2561 message = configHelper.getMissingConfigScreenMessage();
            mc.field_1724.method_7353(message, false);
        }
    }
}

