/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import java.util.Optional;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.core.util.TextHistory;
import mezz.jei.gui.input.GuiTextFieldFilter;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class TextFieldInputHandler
implements IUserInputHandler {
    private final GuiTextFieldFilter textFieldFilter;

    public TextFieldInputHandler(GuiTextFieldFilter textFieldFilter) {
        this.textFieldFilter = textFieldFilter;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (this.handleUserInputBoolean(input, keyBindings)) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    private boolean handleUserInputBoolean(UserInput input, IInternalKeyMappings keyBindings) {
        if (input.is(keyBindings.getEnterKey()) || input.is(keyBindings.getEscapeKey())) {
            return this.handleSetFocused(input, false);
        }
        if (input.is(keyBindings.getFocusSearch())) {
            return this.handleSetFocused(input, true);
        }
        if (input.is(keyBindings.getHoveredClearSearchBar()) && this.textFieldFilter.method_25405(input.getMouseX(), input.getMouseY())) {
            return this.handleHoveredClearSearchBar(input);
        }
        if (input.callVanilla(this.textFieldFilter::method_25405, (arg_0, arg_1, arg_2) -> ((GuiTextFieldFilter)this.textFieldFilter).method_25402(arg_0, arg_1, arg_2), (arg_0, arg_1, arg_2) -> ((GuiTextFieldFilter)this.textFieldFilter).method_25404(arg_0, arg_1, arg_2))) {
            return true;
        }
        if (input.is(keyBindings.getPreviousSearch())) {
            return this.handleNavigateHistory(input, TextHistory.Direction.PREVIOUS);
        }
        if (input.is(keyBindings.getNextSearch())) {
            return this.handleNavigateHistory(input, TextHistory.Direction.NEXT);
        }
        return this.textFieldFilter.method_20315() && input.isAllowedChatCharacter();
    }

    private boolean handleSetFocused(UserInput input, boolean focused) {
        if (this.textFieldFilter.method_25370() != focused) {
            if (!input.isSimulate()) {
                this.textFieldFilter.method_25365(focused);
            }
            return true;
        }
        return false;
    }

    private boolean handleHoveredClearSearchBar(UserInput input) {
        if (!input.isSimulate()) {
            this.textFieldFilter.method_1852("");
            this.textFieldFilter.method_25365(true);
        }
        return true;
    }

    private boolean handleNavigateHistory(UserInput input, TextHistory.Direction direction) {
        if (this.textFieldFilter.method_25370()) {
            return this.textFieldFilter.getHistory(direction).map(newText -> {
                if (!input.isSimulate()) {
                    this.textFieldFilter.method_1852((String)newText);
                }
                return true;
            }).orElse(false);
        }
        return false;
    }

    @Override
    public void handleMouseClickedOut(class_3675.class_306 input) {
        this.textFieldFilter.method_25365(false);
    }
}

