/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.ghost.GhostIngredientDrag;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_918;

public class GhostIngredientReturning<T> {
    private static final long DURATION_PER_SCREEN_WIDTH = 500L;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final T ingredient;
    private final class_241 start;
    private final class_241 end;
    private final long startTime;
    private final long duration;

    public static <T> Optional<GhostIngredientReturning<T>> create(GhostIngredientDrag<T> ghostIngredientDrag, double mouseX, double mouseY) {
        ImmutableRect2i origin = ghostIngredientDrag.getOrigin();
        if (origin.isEmpty()) {
            return Optional.empty();
        }
        IIngredientRenderer<T> ingredientRenderer = ghostIngredientDrag.getIngredientRenderer();
        T ingredient = ghostIngredientDrag.getIngredient();
        class_241 end = new class_241((float)origin.getX(), (float)origin.getY());
        class_241 start = new class_241((float)mouseX - 8.0f, (float)mouseY - 8.0f);
        GhostIngredientReturning<T> returning = new GhostIngredientReturning<T>(ingredientRenderer, ingredient, start, end);
        return Optional.of(returning);
    }

    private GhostIngredientReturning(IIngredientRenderer<T> ingredientRenderer, T ingredient, class_241 start, class_241 end) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredient = ingredient;
        this.start = start;
        this.end = end;
        this.startTime = System.currentTimeMillis();
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen != null) {
            int width = currentScreen.field_22789;
            float durationPerPixel = 500.0f / (float)width;
            float distance = (float)MathUtil.distance(start, end);
            this.duration = Math.round(durationPerPixel * distance);
        } else {
            this.duration = Math.round(250.0f);
        }
    }

    public void drawItem(class_310 minecraft, class_4587 poseStack) {
        long time = System.currentTimeMillis();
        long elapsed = time - this.startTime;
        double percent = Math.min((double)elapsed / (double)this.duration, 1.0);
        double dx = this.end.field_1343 - this.start.field_1343;
        double dy = this.end.field_1342 - this.start.field_1342;
        double x = this.start.field_1343 + (float)Math.round(dx * percent);
        double y = this.start.field_1342 + (float)Math.round(dy * percent);
        class_918 itemRenderer = minecraft.method_1480();
        itemRenderer.field_4730 += 150.0f;
        poseStack.method_22903();
        poseStack.method_22904(x, y, 0.0);
        this.ingredientRenderer.render(poseStack, this.ingredient);
        poseStack.method_22909();
        itemRenderer.field_4730 -= 150.0f;
    }

    public boolean isComplete() {
        long time = System.currentTimeMillis();
        return this.startTime + this.duration < time;
    }
}

