/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.startup;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.network.ClientPacketRouter;
import mezz.jei.core.config.IServerConfig;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.fabric.events.JeiLifecycleEvents;
import mezz.jei.fabric.network.ClientNetworkHandler;
import mezz.jei.fabric.network.ConnectionToServer;
import mezz.jei.fabric.startup.FabricPluginFinder;
import mezz.jei.gui.config.InternalKeyMappings;
import mezz.jei.library.startup.JeiStarter;
import mezz.jei.library.startup.StartData;
import net.minecraft.class_310;
import net.minecraft.class_4013;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientLifecycleHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final JeiStarter jeiStarter;
    private boolean running;

    public ClientLifecycleHandler(Textures textures, IServerConfig serverConfig) {
        ConnectionToServer serverConnection = new ConnectionToServer();
        Internal.setServerConnection(serverConnection);
        InternalKeyMappings keyMappings = new InternalKeyMappings(keyMapping -> {});
        Internal.setKeyMappings(keyMappings);
        IWorldConfig worldConfig = Internal.getWorldConfig();
        ClientPacketRouter packetRouter = new ClientPacketRouter(serverConnection, serverConfig, worldConfig);
        ClientNetworkHandler.registerClientPacketHandler(packetRouter);
        List<IModPlugin> plugins = FabricPluginFinder.getModPlugins();
        StartData startData = new StartData(plugins, textures, serverConnection, keyMappings);
        this.jeiStarter = new JeiStarter(startData);
    }

    public void registerEvents() {
        JeiLifecycleEvents.GAME_START.register(() -> JeiLifecycleEvents.AFTER_RECIPE_SYNC.register(() -> {
            if (this.running) {
                this.stopJei();
            }
            this.startJei();
        }));
        JeiLifecycleEvents.GAME_STOP.register(this::stopJei);
    }

    public class_4013 getReloadListener() {
        return resourceManager -> {
            if (this.running) {
                this.stopJei();
                this.startJei();
            }
        };
    }

    private void startJei() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            LOGGER.error("Failed to start JEI, there is no Minecraft client level.");
            return;
        }
        if (this.running) {
            LOGGER.error("Failed to start JEI, it is already running.");
            return;
        }
        this.jeiStarter.start();
        this.running = true;
    }

    private void stopJei() {
        LOGGER.info("Stopping JEI");
        this.jeiStarter.stop();
        this.running = false;
    }
}

