/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.platform;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.core.util.function.CachedSupplier;
import mezz.jei.fabric.platform.ConfigHelper;
import mezz.jei.fabric.platform.FluidHelper;
import mezz.jei.fabric.platform.IngredientHelper;
import mezz.jei.fabric.platform.InputHelper;
import mezz.jei.fabric.platform.ItemStackHelper;
import mezz.jei.fabric.platform.ModHelper;
import mezz.jei.fabric.platform.RecipeHelper;
import mezz.jei.fabric.platform.RegistryWrapper;
import mezz.jei.fabric.platform.RenderHelper;
import mezz.jei.fabric.platform.ScreenHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

public class PlatformHelper
implements IPlatformHelper {
    private final CachedSupplier<ItemStackHelper> itemStackHelper = new CachedSupplier<ItemStackHelper>(ItemStackHelper::new);
    private final CachedSupplier<FluidHelper> fluidHelper = new CachedSupplier<FluidHelper>(FluidHelper::new);
    private final CachedSupplier<RenderHelper> renderHelper = new CachedSupplier<RenderHelper>(RenderHelper::new);
    private final CachedSupplier<RecipeHelper> recipeHelper = new CachedSupplier<RecipeHelper>(RecipeHelper::new);
    private final CachedSupplier<ConfigHelper> configHelper = new CachedSupplier<ConfigHelper>(ConfigHelper::new);
    private final CachedSupplier<InputHelper> inputHelper = new CachedSupplier<InputHelper>(InputHelper::new);
    private final CachedSupplier<ScreenHelper> screenHelper = new CachedSupplier<ScreenHelper>(ScreenHelper::new);
    private final CachedSupplier<IngredientHelper> ingredientHelper = new CachedSupplier<IngredientHelper>(IngredientHelper::new);
    private final CachedSupplier<ModHelper> modHelper = new CachedSupplier<ModHelper>(ModHelper::new);

    @Override
    public <T> IPlatformRegistry<T> getRegistry(class_5321<? extends class_2378<T>> key) {
        return RegistryWrapper.getRegistry(key);
    }

    @Override
    public ItemStackHelper getItemStackHelper() {
        return this.itemStackHelper.get();
    }

    @Override
    public IPlatformFluidHelperInternal<?> getFluidHelper() {
        return this.fluidHelper.get();
    }

    @Override
    public RenderHelper getRenderHelper() {
        return this.renderHelper.get();
    }

    @Override
    public RecipeHelper getRecipeHelper() {
        return this.recipeHelper.get();
    }

    @Override
    public ConfigHelper getConfigHelper() {
        return this.configHelper.get();
    }

    @Override
    public InputHelper getInputHelper() {
        return this.inputHelper.get();
    }

    @Override
    public ScreenHelper getScreenHelper() {
        return this.screenHelper.get();
    }

    @Override
    public IngredientHelper getIngredientHelper() {
        return this.ingredientHelper.get();
    }

    @Override
    public ModHelper getModHelper() {
        return this.modHelper.get();
    }

    @Override
    public Path createConfigDir() {
        Path configDir = FabricLoader.getInstance().getConfigDir().resolve("jei");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create JEI config directory: " + configDir, e);
        }
        return configDir;
    }
}

