/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.network;

import java.util.EnumMap;
import java.util.Optional;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.network.packets.IServerPacketHandler;
import mezz.jei.common.network.packets.PacketDeletePlayerItem;
import mezz.jei.common.network.packets.PacketGiveItemStack;
import mezz.jei.common.network.packets.PacketRecipeTransfer;
import mezz.jei.common.network.packets.PacketRequestCheatPermission;
import mezz.jei.common.network.packets.PacketSetHotbarItemStack;
import mezz.jei.core.config.IServerConfig;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPacketRouter {
    private static final Logger LOGGER = LogManager.getLogger();
    public final EnumMap<PacketIdServer, IServerPacketHandler> handlers = new EnumMap(PacketIdServer.class);
    private final IConnectionToClient connection;
    private final IServerConfig serverConfig;

    public ServerPacketRouter(IConnectionToClient connection, IServerConfig serverConfig) {
        this.connection = connection;
        this.serverConfig = serverConfig;
        this.handlers.put(PacketIdServer.RECIPE_TRANSFER, PacketRecipeTransfer::readPacketData);
        this.handlers.put(PacketIdServer.DELETE_ITEM, PacketDeletePlayerItem::readPacketData);
        this.handlers.put(PacketIdServer.GIVE_ITEM, PacketGiveItemStack::readPacketData);
        this.handlers.put(PacketIdServer.SET_HOTBAR_ITEM, PacketSetHotbarItemStack::readPacketData);
        this.handlers.put(PacketIdServer.CHEAT_PERMISSION_REQUEST, PacketRequestCheatPermission::readPacketData);
    }

    public void onPacket(class_2540 packetBuffer, class_3222 player) {
        this.getPacketId(packetBuffer).ifPresent(packetId -> {
            IServerPacketHandler packetHandler = this.handlers.get(packetId);
            ServerPacketContext context = new ServerPacketContext(player, this.serverConfig, this.connection);
            ServerPacketData data = new ServerPacketData(packetBuffer, context);
            try {
                packetHandler.readPacketData(data).exceptionally(e -> {
                    LOGGER.error("Packet error while executing packet on the server thread: {}", (Object)packetId.name(), e);
                    return null;
                });
            }
            catch (Throwable e2) {
                LOGGER.error("Packet error when reading packet: {}", (Object)packetId.name(), (Object)e2);
            }
        });
    }

    private Optional<PacketIdServer> getPacketId(class_2540 packetBuffer) {
        try {
            byte packetIdOrdinal = packetBuffer.readByte();
            PacketIdServer packetId = PacketIdServer.VALUES[packetIdOrdinal];
            return Optional.of(packetId);
        }
        catch (RuntimeException e) {
            LOGGER.error("Packet error when trying to read packet id", (Throwable)e);
            return Optional.empty();
        }
    }
}

