package mezz.jei.fabric.startup;

import mezz.jei.common.gui.GuiEventHandler;
import mezz.jei.common.input.ClientInputHandler;
import mezz.jei.common.input.InputType;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.startup.JeiEventHandlers;
import mezz.jei.fabric.events.JeiCharTypedEvents;
import mezz.jei.fabric.events.JeiScreenEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;

public class EventRegistration {
	@Nullable
	private ClientInputHandler clientInputHandler;
	@Nullable
	private GuiEventHandler guiEventHandler;
	private boolean registered;

	public void setEventHandlers(JeiEventHandlers eventHandlers) {
		clientInputHandler = eventHandlers.clientInputHandler();
		guiEventHandler = eventHandlers.guiEventHandler();
		if (!registered) {
			registerEvents();
			registered = true;
		}
	}

	private void registerEvents() {
		ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) ->
			registerScreenEvents(screen)
		);
		JeiCharTypedEvents.BEFORE_CHAR_TYPED.register(this::beforeCharTyped);
		ScreenEvents.AFTER_INIT.register(this::afterInit);
		JeiScreenEvents.AFTER_RENDER_BACKGROUND.register(this::afterRenderBackground);
		JeiScreenEvents.DRAW_FOREGROUND.register(this::drawForeground);
		ClientTickEvents.START_CLIENT_TICK.register(this::onStartTick);
	}

	private void registerScreenEvents(class_437 screen) {
		if (guiEventHandler == null) {
			return;
		}

		guiEventHandler.onGuiInit(screen);
		ScreenKeyboardEvents.allowKeyPress(screen).register(this::allowKeyPress);
		ScreenMouseEvents.allowMouseClick(screen).register(this::allowMouseClick);
		ScreenMouseEvents.beforeMouseRelease(screen).register(this::beforeMouseRelease);
		ScreenMouseEvents.allowMouseScroll(screen).register(this::allowMouseScroll);
		ScreenEvents.afterRender(screen).register(this::afterRender);
	}

	private boolean allowMouseClick(class_437 screen, double mouseX, double mouseY, int button) {
		if (clientInputHandler == null) {
			return true;
		}
		return UserInput.fromVanilla(mouseX, mouseY, button, InputType.SIMULATE)
			.map(input -> !clientInputHandler.onGuiMouseClicked(screen, input))
			.orElse(true);
	}

	@SuppressWarnings("UnusedReturnValue")
	private boolean beforeMouseRelease(class_437 screen, double mouseX, double mouseY, int button) {
		if (clientInputHandler == null) {
			return true;
		}
		return UserInput.fromVanilla(mouseX, mouseY, button, InputType.EXECUTE)
			.map(input -> !clientInputHandler.onGuiMouseReleased(screen, input))
			.orElse(true);
	}

	private boolean allowKeyPress(class_437 screen, int key, int scancode, int modifiers) {
		if (clientInputHandler == null) {
			return true;
		}
		UserInput userInput = UserInput.fromVanilla(key, scancode, modifiers, InputType.IMMEDIATE);
		return !clientInputHandler.onKeyboardKeyPressedPre(screen, userInput);
	}

	private boolean allowMouseScroll(class_437 screen, double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
		if (clientInputHandler == null) {
			return false;
		}
		return !clientInputHandler.onGuiMouseScroll(mouseX, mouseY, verticalAmount);
	}

	private void afterRender(class_437 screen, class_4587 poseStack, int mouseX, int mouseY, float tickDelta) {
		if (guiEventHandler != null) {
			guiEventHandler.onDrawScreenPost(screen, poseStack, mouseX, mouseY);
		}
	}

	private boolean beforeCharTyped(class_364 guiEventListener, char codepoint, int modifiers) {
		if (clientInputHandler != null && guiEventListener instanceof class_437 screen) {
			return clientInputHandler.onKeyboardCharTypedPre(screen, codepoint, modifiers);
		}
		return false;
	}

	private void afterInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
		if (guiEventHandler != null) {
			guiEventHandler.onGuiOpen(screen);
		}
	}

	private void afterRenderBackground(class_437 screen, class_4587 poseStack) {
		if (guiEventHandler != null) {
			guiEventHandler.onDrawBackgroundPost(screen, poseStack);
		}
	}

	private void drawForeground(class_465<?> screen, class_4587 poseStack, int mouseX, int mouseY) {
		if (guiEventHandler != null) {
			guiEventHandler.onDrawForeground(screen, poseStack, mouseX, mouseY);
		}
	}

	private void onStartTick(class_310 client) {
		if (guiEventHandler != null) {
			guiEventHandler.onClientTick();
		}
	}

	public void clear() {
		this.clientInputHandler = null;
		this.guiEventHandler = null;
	}
}
