package mezz.jei.common.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.packets.PacketCheatPermission;
import mezz.jei.core.config.GiveMode;
import mezz.jei.core.config.IServerConfig;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

/**
 * Server-side-safe utilities for commands.
 */
public final class ServerCommandUtil {
	private static final Logger LOGGER = LogManager.getLogger();

	private ServerCommandUtil() {
	}

	public static boolean hasPermissionForCheatMode(class_3222 sender, IServerConfig serverConfig) {
		if (serverConfig.isCheatModeEnabledForCreative() &&
			sender.method_7337()) {
			return true;
		}

		class_2168 commandSource = sender.method_5671();
		if (serverConfig.isCheatModeEnabledForOp()) {
			MinecraftServer minecraftServer = sender.method_5682();
			if (minecraftServer != null) {
				int opPermissionLevel = minecraftServer.method_3798();
				return commandSource.method_9259(opPermissionLevel);
			}
		}

		if (serverConfig.isCheatModeEnabledForGive()) {
			CommandNode<class_2168> giveCommand = getGiveCommand(sender);
			if (giveCommand != null) {
				return giveCommand.canUse(commandSource);
			}
		}

		return false;
	}

	/**
	 * Gives a player an item.
	 */
	public static void executeGive(
		ServerPacketContext context,
		class_1799 itemStack,
		GiveMode giveMode
	) {
		class_3222 sender = context.player();
		IServerConfig serverConfig = context.serverConfig();
		if (hasPermissionForCheatMode(sender, serverConfig)) {
			if (itemStack.method_7960()) {
				if (LOGGER.isDebugEnabled()) {
					LOGGER.debug("Player '{} ({})' tried to give an empty ItemStack.", sender.method_5477(), sender.method_5667());
				}
				return;
			}
			if (giveMode == GiveMode.INVENTORY) {
				giveToInventory(sender, itemStack);
			} else if (giveMode == GiveMode.MOUSE_PICKUP) {
				mousePickupItemStack(sender, itemStack);
			}
		} else {
			if (LOGGER.isDebugEnabled()) {
				LOGGER.debug("Player '{} ({})' tried to cheat an ItemStack '{}' but does not have permission.", sender.method_5477(), sender.method_5667(), itemStack.method_7954());
			}
			IConnectionToClient connection = context.connection();
			connection.sendPacketToClient(new PacketCheatPermission(false), sender);
		}
	}

	public static void setHotbarSlot(
		ServerPacketContext context,
		class_1799 itemStack,
		int hotbarSlot
	) {
		class_3222 sender = context.player();
		IServerConfig serverConfig = context.serverConfig();
		if (hasPermissionForCheatMode(sender, serverConfig)) {
			if (itemStack.method_7960()) {
				if (LOGGER.isDebugEnabled()) {
					LOGGER.debug("Player '{} ({})' tried to set an empty ItemStack to the hotbar slot: {}", sender.method_5477(), sender.method_5667(), hotbarSlot);
				}
				return;
			}
			if (!class_1661.method_7380(hotbarSlot)) {
				if (LOGGER.isDebugEnabled()) {
					LOGGER.debug("Player '{} ({})' tried to set slot that is not in the hotbar: {}", sender.method_5477(), sender.method_5667(), hotbarSlot);
				}
				return;
			}
			class_1799 stackInSlot = sender.method_31548().method_5438(hotbarSlot);
			if (class_1799.method_7973(stackInSlot, itemStack)) {
				return;
			}
			class_1799 itemStackCopy = itemStack.method_7972();
			sender.method_31548().method_5447(hotbarSlot, itemStack);
			sender.field_6002.method_43128(null, sender.method_23317(), sender.method_23318(), sender.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2F, ((sender.method_6051().method_43057() - sender.method_6051().method_43057()) * 0.7F + 1.0F) * 2.0F);
			sender.field_7498.method_7623();
			notifyGive(sender, itemStackCopy);
		} else {
			if (LOGGER.isDebugEnabled()) {
				LOGGER.debug("Player '{} ({})' tried to cheat an item '{}' to their hotbar but does not have permission.", sender.method_5477(), sender.method_5667(), itemStack.method_7954());
			}
			IConnectionToClient connection = context.connection();
			connection.sendPacketToClient(new PacketCheatPermission(false), sender);
		}
	}

	public static void mousePickupItemStack(class_1657 sender, class_1799 itemStack) {
		class_1703 containerMenu = sender.field_7512;

		class_1799 itemStackCopy = itemStack.method_7972();
		class_1799 existingStack = containerMenu.method_34255();

		final int giveCount;
		if (canStack(existingStack, itemStack)) {
			int newCount = Math.min(existingStack.method_7914(), existingStack.method_7947() + itemStack.method_7947());
			giveCount = newCount - existingStack.method_7947();
			existingStack.method_7939(newCount);
		} else {
			containerMenu.method_34254(itemStack);
			giveCount = itemStack.method_7947();
		}

		if (giveCount > 0) {
			itemStackCopy.method_7939(giveCount);
			notifyGive(sender, itemStackCopy);
			containerMenu.method_7623();
		}
	}

	public static boolean canStack(class_1799 a, class_1799 b) {
		class_1799 singleStack = a.method_7972();
		singleStack.method_7939(1);
		return class_1542.method_24017(singleStack, b);
	}

	/**
	 * Gives a player an item.
	 *
	 * @see GiveCommand#giveItem(CommandSource, ItemInput, Collection, int)
	 */
	@SuppressWarnings("JavadocReference")
	private static void giveToInventory(class_1657 entityplayermp, class_1799 itemStack) {
		class_1799 itemStackCopy = itemStack.method_7972();
		boolean flag = entityplayermp.method_31548().method_7394(itemStack);
		if (flag && itemStack.method_7960()) {
			itemStack.method_7939(1);
			class_1542 entityitem = entityplayermp.method_7328(itemStack, false);
			if (entityitem != null) {
				entityitem.method_6987();
			}

			entityplayermp.field_6002.method_43128(null, entityplayermp.method_23317(), entityplayermp.method_23318(), entityplayermp.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2F, ((entityplayermp.method_6051().method_43057() - entityplayermp.method_6051().method_43057()) * 0.7F + 1.0F) * 2.0F);
			entityplayermp.field_7498.method_7623();
		} else {
			class_1542 entityitem = entityplayermp.method_7328(itemStack, false);
			if (entityitem != null) {
				entityitem.method_6975();
				entityitem.method_6984(entityplayermp.method_5667());
			}
		}

		notifyGive(entityplayermp, itemStackCopy);
	}

	private static void notifyGive(class_1657 player, class_1799 stack) {
		if (player.method_5682() == null) {
			return;
		}
		class_2168 commandSource = player.method_5671();
		int count = stack.method_7947();
		class_2561 stackTextComponent = stack.method_7954();
		class_2561 displayName = player.method_5476();
		class_2561 message = class_2561.method_43469("commands.give.success.single", count, stackTextComponent, displayName);
		commandSource.method_9226(message, true);
	}

	@Nullable
	private static CommandNode<class_2168> getGiveCommand(class_1657 sender) {
		MinecraftServer minecraftServer = sender.method_5682();
		if (minecraftServer == null) {
			return null;
		}
		class_2170 commandManager = minecraftServer.method_3734();
		CommandDispatcher<class_2168> dispatcher = commandManager.method_9235();
		RootCommandNode<class_2168> root = dispatcher.getRoot();
		return root.getChild("give");
	}
}
