package mezz.jei.common.util;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.ingredients.IngredientSet;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class BrewingRecipeMakerCommon {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Set<IJeiBrewingRecipe> getVanillaBrewingRecipes(
        IVanillaRecipeFactory recipeFactory,
        IIngredientManager ingredientManager,
        IVanillaPotionOutputSupplier vanillaOutputSupplier
    ) {
        Set<IJeiBrewingRecipe> recipes = new HashSet<>();
        IPlatformRegistry<class_1842> potionRegistry = Services.PLATFORM.getRegistry(class_2378.field_25109);
        IngredientSet<class_1799> knownPotions = getBaseKnownPotions(ingredientManager, potionRegistry);

        List<class_1799> potionReagents = ingredientManager.getAllItemStacks().stream()
            .filter(BrewingRecipeMakerCommon::isIngredient)
            .toList();

        boolean foundNewPotions;
        do {
            List<class_1799> newPotions = getNewPotions(
                recipeFactory,
                potionRegistry,
                knownPotions,
                potionReagents,
                vanillaOutputSupplier,
                recipes
            );
            foundNewPotions = !newPotions.isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);

        return recipes;
    }

    private static boolean isIngredient(class_1799 itemStack) {
        try {
            return class_1845.method_8077(itemStack);
        } catch (RuntimeException | LinkageError e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Failed to check if item is a potion reagent {}.", itemStackInfo, e);
            return false;
        }
    }

    private static IngredientSet<class_1799> getBaseKnownPotions(IIngredientManager ingredientManager, IPlatformRegistry<class_1842> potionRegistry) {
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        List<class_1799> potionContainers = ingredientHelper.getPotionContainers().stream()
            .flatMap(potionItem -> Arrays.stream(potionItem.method_8105()))
            .toList();

        IIngredientHelper<class_1799> itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IngredientSet<class_1799> knownPotions = IngredientSet.create(itemStackHelper, UidContext.Ingredient);

        potionRegistry.getValues()
            .filter(potion -> potion != class_1847.field_8984) // skip the "un-craft-able" vanilla potions
            .forEach(potion -> {
                for (class_1799 potionContainer : potionContainers) {
                    class_1799 result = class_1844.method_8061(potionContainer.method_7972(), potion);
                    knownPotions.add(result);
                }
            });
        return knownPotions;
    }

    private static List<class_1799> getNewPotions(
        IVanillaRecipeFactory recipeFactory,
        IPlatformRegistry<class_1842> potionRegistry,
        Collection<class_1799> knownPotions,
        List<class_1799> potionReagents,
        IVanillaPotionOutputSupplier vanillaOutputSupplier,
        Collection<IJeiBrewingRecipe> recipes
    ) {
        List<class_1799> newPotions = new ArrayList<>();
        for (class_1799 potionInput : knownPotions) {
            for (class_1799 potionReagent : potionReagents) {
                class_1799 potionOutput = vanillaOutputSupplier.getOutput(potionInput.method_7972(), potionReagent);
                if (potionOutput.method_7960()) {
                    continue;
                }

                if (potionInput.method_7909() == potionOutput.method_7909()) {
                    class_1842 potionOutputType = class_1844.method_8063(potionOutput);
                    if (potionOutputType == class_1847.field_8991) {
                        continue;
                    }

                    class_1842 potionInputType = class_1844.method_8063(potionInput);
                    class_2960 inputId = potionRegistry.getRegistryName(potionInputType);
                    class_2960 outputId = potionRegistry.getRegistryName(potionOutputType);
                    if (Objects.equals(inputId, outputId)) {
                        continue;
                    }
                }

                IJeiBrewingRecipe recipe = recipeFactory.createBrewingRecipe(List.of(potionReagent), potionInput.method_7972(), potionOutput);
                if (!recipes.contains(recipe)) {
                    recipes.add(recipe);
                    newPotions.add(potionOutput);
                }
            }
        }
        return newPotions;
    }

    @FunctionalInterface
    public interface IVanillaPotionOutputSupplier {
        class_1799 getOutput(class_1799 input, class_1799 ingredient);
    }
}
