package mezz.jei.common.plugins.vanilla.cooking.fuel;

import com.google.common.base.Preconditions;
import mezz.jei.api.recipe.vanilla.IJeiFuelingRecipe;
import net.minecraft.class_1799;
import java.util.Collection;
import java.util.List;

public class FuelingRecipe implements IJeiFuelingRecipe {
	private final List<class_1799> inputs;
	private final int burnTime;

	public FuelingRecipe(Collection<class_1799> input, int burnTime) {
		Preconditions.checkArgument(burnTime > 0, "burn time must be greater than 0");
		this.inputs = List.copyOf(input);
		this.burnTime = burnTime;
	}

	@Override
	public List<class_1799> getInputs() {
		return inputs;
	}

	@Override
	public int getBurnTime() {
		return burnTime;
	}
}
