package mezz.jei.common.plugins.vanilla.cooking;

import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.common.Constants;
import net.minecraft.class_2246;
import net.minecraft.class_3920;
import net.minecraft.class_4587;

public class CampfireCookingCategory extends AbstractCookingCategory<class_3920> {
	private final IDrawable background;

	public CampfireCookingCategory(IGuiHelper guiHelper) {
		super(guiHelper, class_2246.field_17350, "gui.jei.category.campfire", 400);
		background = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 0, 186, 82, 34)
			.addPadding(0, 10, 0, 0)
			.build();
	}

	@Override
	public RecipeType<class_3920> getRecipeType() {
		return RecipeTypes.CAMPFIRE_COOKING;
	}

	@Override
	public IDrawable getBackground() {
		return background;
	}

	@Override
	public void draw(class_3920 recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		animatedFlame.draw(poseStack, 1, 20);
		IDrawableAnimated arrow = getArrow(recipe);
		arrow.draw(poseStack, 24, 8);
		drawCookTime(recipe, poseStack, 35);
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, class_3920 recipe, IFocusGroup focuses) {
		builder.addSlot(RecipeIngredientRole.INPUT, 1, 1)
			.addIngredients(recipe.method_8117().get(0));

		builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 9)
			.addItemStack(recipe.method_8110());
	}
}
