package mezz.jei.common.plugins.debug;

import mezz.jei.api.constants.ModIds;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3612;
import java.util.List;

public class DebugFocusRecipeCategory<F> implements IRecipeCategory<DebugRecipe> {
	public static final RecipeType<DebugRecipe> TYPE = RecipeType.create(ModIds.JEI_ID, "debug_focus", DebugRecipe.class);
	public static final int RECIPE_WIDTH = 160;
	public static final int RECIPE_HEIGHT = 60;
	private final IDrawable background;
	private final IPlatformFluidHelper<F> platformFluidHelper;
	private final class_2561 localizedName;

	public DebugFocusRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<F> platformFluidHelper) {
		this.background = guiHelper.createBlankDrawable(RECIPE_WIDTH, RECIPE_HEIGHT);
		this.platformFluidHelper = platformFluidHelper;
		this.localizedName = class_2561.method_43470("debug_focus");
	}

	@Override
	public RecipeType<DebugRecipe> getRecipeType() {
		return TYPE;
	}

	@Override
	public class_2561 getTitle() {
		return localizedName;
	}

	@Override
	public IDrawable getBackground() {
		return background;
	}

	@Override
	public IDrawable getIcon() {
		Textures textures = Internal.getTextures();
		return textures.getConfigButtonIcon();
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
		IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 0, 0)
			.addItemStacks(List.of(
				new class_1799(class_1802.field_8550),
				new class_1799(class_1802.field_8705),
				new class_1799(class_1802.field_8187),
				new class_1799(class_1802.field_27876),
				new class_1799(class_1802.field_28354),
				new class_1799(class_1802.field_8714),
				new class_1799(class_1802.field_8666),
				new class_1799(class_1802.field_8108),
				new class_1799(class_1802.field_8478)
			));

		long bucketVolume = platformFluidHelper.bucketVolume();
		IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 20, 0)
			.addItemStack(class_1799.field_8037)
			.addIngredients(platformFluidHelper.getFluidIngredientType(), List.of(
				platformFluidHelper.create(class_3612.field_15910, bucketVolume),
				platformFluidHelper.create(class_3612.field_15908, bucketVolume)
			))
			.addItemStacks(List.of(
				new class_1799(class_1802.field_8246),
				new class_1799(class_1802.field_28355),
				new class_1799(class_1802.field_8209),
				new class_1799(class_1802.field_8429),
				new class_1799(class_1802.field_8323),
				new class_1799(class_1802.field_8846)
			));

		IIngredientAcceptor<?> invisibleSlot = builder.addInvisibleIngredients(RecipeIngredientRole.INPUT)
			.addItemStacks(List.of(
				new class_1799(class_1802.field_8094),
				new class_1799(class_1802.field_8605),
				new class_1799(class_1802.field_8758),
				new class_1799(class_1802.field_8820),
				new class_1799(class_1802.field_8651),
				new class_1799(class_1802.field_8646),
				new class_1799(class_1802.field_8114),
				new class_1799(class_1802.field_17507),
				new class_1799(class_1802.field_8173)
			));

		builder.createFocusLink(inputSlot, outputSlot, invisibleSlot);
	}

}
