package mezz.jei.common.platform;

import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2960;

public interface IPlatformRegistry<T> {
    Stream<T> getValues();

    @Nullable
    T getValue(class_2960 resourceLocation);

    int getId(T entry);

    Optional<T> getValue(int id);

    boolean contains(T entry);

    @Nullable
    class_2960 getRegistryName(T entry);
}
