package mezz.jei.common.network.packets;

import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.IPacketId;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IServerConfig;
import mezz.jei.common.util.ServerCommandUtil;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.concurrent.CompletableFuture;

public class PacketDeletePlayerItem extends PacketJei {
	private static final Logger LOGGER = LogManager.getLogger();

	private final class_1799 itemStack;

	public PacketDeletePlayerItem(class_1799 itemStack) {
		this.itemStack = itemStack;
	}

	@Override
	public IPacketId getPacketId() {
		return PacketIdServer.DELETE_ITEM;
	}

	@Override
	public void writePacketData(class_2540 buf) {
		IPlatformRegistry<class_1792> registry = Services.PLATFORM.getRegistry(class_2378.field_25108);
		int itemId = registry.getId(itemStack.method_7909());
		buf.method_10804(itemId);
	}

	public static CompletableFuture<Void> readPacketData(ServerPacketData data) {
		class_2540 buf = data.buf();
		ServerPacketContext context = data.context();
		class_3222 player = context.player();
		int itemId = buf.method_10816();

		return Services.PLATFORM
			.getRegistry(class_2378.field_25108)
			.getValue(itemId)
			.map(item -> {
				MinecraftServer server = player.field_13995;
				return server.method_20493(() -> deletePlayerItem(player, context, item));
			})
			.orElseGet(() -> {
				if (LOGGER.isDebugEnabled()) {
					LOGGER.debug("Player '{} ({})' tried to delete Item ID '{}' but no item is registered with that ID.", player.method_5477(), player.method_5667(), itemId);
				}
				return CompletableFuture.completedFuture(null);
			});
	}

	private static void deletePlayerItem(class_3222 player, ServerPacketContext context, class_1792 item) {
		IServerConfig serverConfig = context.serverConfig();
		if (ServerCommandUtil.hasPermissionForCheatMode(player, serverConfig)) {
			class_1799 playerItem = player.field_7512.method_34255();
			if (playerItem.method_7909() == item) {
				player.field_7512.method_34254(class_1799.field_8037);
			} else {
				if (LOGGER.isDebugEnabled()) {
					LOGGER.debug("Player '{} ({})' tried to delete Item '{}' but is currently holding a different ItemStack '{}'.", player.method_5477(), player.method_5667(), item, playerItem.method_7954());
				}
			}
		} else {
			if (LOGGER.isDebugEnabled()) {
				class_1799 playerItem = player.field_7512.method_34255();
				LOGGER.debug("Player '{} ({})' tried to delete ItemStack '{}' but does not have permission.", player.method_5477(), player.method_5667(), playerItem.method_7954());
			}
			IConnectionToClient connection = context.connection();
			connection.sendPacketToClient(new PacketCheatPermission(false), player);
		}
	}
}
