package mezz.jei.common.gui.overlay;

import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.color.ColorNamer;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.core.search.SearchMode;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.ingredients.IngredientInfo;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.render.IngredientRenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class IngredientGridTooltipHelper {
	private final RegisteredIngredients registeredIngredients;
	private final IIngredientFilterConfig ingredientFilterConfig;
	private final IWorldConfig worldConfig;
	private final IModIdHelper modIdHelper;
	private final IInternalKeyMappings keyBindings;

	public IngredientGridTooltipHelper(
		RegisteredIngredients registeredIngredients,
		IIngredientFilterConfig ingredientFilterConfig,
		IWorldConfig worldConfig,
		IModIdHelper modIdHelper,
		IInternalKeyMappings keyBindings
	) {
		this.registeredIngredients = registeredIngredients;
		this.ingredientFilterConfig = ingredientFilterConfig;
		this.worldConfig = worldConfig;
		this.modIdHelper = modIdHelper;
		this.keyBindings = keyBindings;
	}

	public <T> void drawTooltip(class_4587 poseStack, int mouseX, int mouseY, ITypedIngredient<T> value) {
		IIngredientType<T> ingredientType = value.getType();
		T ingredient = value.getIngredient();
		IngredientInfo<T> ingredientInfo = registeredIngredients.getIngredientInfo(ingredientType);
		IIngredientRenderer<T> ingredientRenderer = ingredientInfo.getIngredientRenderer();

		List<class_2561> tooltip = getTooltip(ingredient, ingredientInfo);
		TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY, ingredient, ingredientRenderer);
	}

	public <T> List<class_2561> getTooltip(T ingredient, IngredientInfo<T> ingredientInfo) {
		IIngredientRenderer<T> ingredientRenderer = ingredientInfo.getIngredientRenderer();
		IIngredientHelper<T> ingredientHelper = ingredientInfo.getIngredientHelper();
		List<class_2561> ingredientTooltipSafe = IngredientRenderHelper.getIngredientTooltipSafe(ingredient, ingredientRenderer, ingredientHelper, modIdHelper);
		List<class_2561> tooltip = new ArrayList<>(ingredientTooltipSafe);

		if (ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
			addColorSearchInfoToTooltip(tooltip, ingredient, ingredientInfo);
		}

		if (worldConfig.isEditModeEnabled()) {
			addEditModeInfoToTooltip(tooltip, keyBindings);
		}

		return tooltip;
	}

	private static <T> void addColorSearchInfoToTooltip(List<class_2561> tooltip, T ingredient, IngredientInfo<T> ingredientInfo) {
		ColorNamer colorNamer = ColorNamer.getInstance();

		IIngredientHelper<T> ingredientHelper = ingredientInfo.getIngredientHelper();
		Iterable<Integer> colors = ingredientHelper.getColors(ingredient);
		String colorNamesString = colorNamer.getColorNames(colors)
				.collect(Collectors.joining(", "));
		if (!colorNamesString.isEmpty()) {
			class_2561 colorTranslation = class_2561.method_43469("jei.tooltip.item.colors", colorNamesString)
				.method_27692(class_124.field_1080);
			tooltip.add(colorTranslation);
		}
	}

	private static void addEditModeInfoToTooltip(List<class_2561> tooltip, IInternalKeyMappings keyBindings) {
		List<class_2561> lines = List.of(
			class_5244.field_39003,
			class_2561.method_43471("gui.jei.editMode.description")
				.method_27692(class_124.field_1077),
			class_2561.method_43469(
				"gui.jei.editMode.description.hide",
				keyBindings.getToggleHideIngredient().getTranslatedKeyMessage()
			).method_27692(class_124.field_1080),
			class_2561.method_43469(
				"gui.jei.editMode.description.hide.wild",
				keyBindings.getToggleWildcardHideIngredient().getTranslatedKeyMessage()
			).method_27692(class_124.field_1080)
		);
		tooltip.addAll(lines);
	}
}
