package mezz.jei.common.gui;

import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.common.gui.overlay.IngredientListOverlay;
import mezz.jei.common.gui.overlay.bookmarks.LeftAreaDispatcher;
import mezz.jei.common.input.MouseUtil;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.LimitedLogger;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.time.Duration;
import java.util.List;

public class GuiEventHandler {
	private static final Logger LOGGER = LogManager.getLogger();
	private static final LimitedLogger missingBackgroundLogger = new LimitedLogger(LOGGER, Duration.ofHours(1));

	private final IngredientListOverlay ingredientListOverlay;
	private final GuiScreenHelper guiScreenHelper;
	private final LeftAreaDispatcher leftAreaDispatcher;
	private boolean drawnOnBackground = false;

	public GuiEventHandler(
		GuiScreenHelper guiScreenHelper,
		LeftAreaDispatcher leftAreaDispatcher,
		IngredientListOverlay ingredientListOverlay
	) {
		this.guiScreenHelper = guiScreenHelper;
		this.leftAreaDispatcher = leftAreaDispatcher;
		this.ingredientListOverlay = ingredientListOverlay;
	}

	public void onGuiInit(class_437 screen) {
		ingredientListOverlay.updateScreen(screen, false);
		leftAreaDispatcher.updateScreen(screen, false);
	}

	public void onGuiOpen(class_437 screen) {
		ingredientListOverlay.updateScreen(screen, false);
		leftAreaDispatcher.updateScreen(screen, false);
	}

	public void onDrawBackgroundPost(class_437 screen, class_4587 poseStack) {
		class_310 minecraft = class_310.method_1551();
		boolean exclusionAreasChanged = guiScreenHelper.updateGuiExclusionAreas(screen);
		ingredientListOverlay.updateScreen(screen, exclusionAreasChanged);
		leftAreaDispatcher.updateScreen(screen, exclusionAreasChanged);

		drawnOnBackground = true;
		double mouseX = MouseUtil.getX();
		double mouseY = MouseUtil.getY();
		ingredientListOverlay.drawScreen(minecraft, poseStack, (int) mouseX, (int) mouseY, minecraft.method_1488());
		leftAreaDispatcher.drawScreen(minecraft, poseStack, (int) mouseX, (int) mouseY, minecraft.method_1488());
	}

	/**
	 * Draws above most ContainerScreen elements, but below the tooltips.
	 */
	public void onDrawForeground(class_465<?> screen, class_4587 poseStack, int mouseX, int mouseY) {
		class_310 minecraft = class_310.method_1551();
		ingredientListOverlay.drawOnForeground(minecraft, poseStack, screen, mouseX, mouseY);
	}

	public void onDrawScreenPost(class_437 screen, class_4587 poseStack, int mouseX, int mouseY) {
		class_310 minecraft = class_310.method_1551();

		ingredientListOverlay.updateScreen(screen, false);
		leftAreaDispatcher.updateScreen(screen, false);

		if (!drawnOnBackground) {
			if (screen instanceof class_465) {
				String guiName = screen.getClass().getName();
				missingBackgroundLogger.log(Level.WARN, guiName, "GUI did not draw the dark background layer behind itself, this may result in display issues: {}", guiName);
			}
			ingredientListOverlay.drawScreen(minecraft, poseStack, mouseX, mouseY, minecraft.method_1488());
			leftAreaDispatcher.drawScreen(minecraft, poseStack, mouseX, mouseY, minecraft.method_1488());
		}
		drawnOnBackground = false;

		if (screen instanceof class_465<?> guiContainer) {
			IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
			int guiLeft = screenHelper.getGuiLeft(guiContainer);
			int guiTop = screenHelper.getGuiTop(guiContainer);
			guiScreenHelper.getGuiClickableArea(guiContainer, mouseX - guiLeft, mouseY - guiTop)
				.filter(IGuiClickableArea::isTooltipEnabled)
				.map(IGuiClickableArea::getTooltipStrings)
				.ifPresent(tooltipStrings -> {
					if (tooltipStrings.isEmpty()) {
						tooltipStrings = List.of(class_2561.method_43471("jei.tooltip.show.recipes"));
					}
					TooltipRenderer.drawHoveringText(poseStack, tooltipStrings, mouseX, mouseY);
				});
		}

		ingredientListOverlay.drawTooltips(minecraft, poseStack, mouseX, mouseY);
		leftAreaDispatcher.drawTooltips(minecraft, poseStack, mouseX, mouseY);
	}

	public void onClientTick() {
		ingredientListOverlay.handleTick();
	}

	public boolean renderCompactPotionIndicators() {
		return ingredientListOverlay.isListDisplayed();
	}
}
