package mezz.jei.common.config;

import mezz.jei.api.constants.ModIds;
import mezz.jei.common.config.file.IConfigCategoryBuilder;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import mezz.jei.common.config.file.serializers.ChatFormattingSerializer;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.util.function.CachedSupplierTransformer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ModIdFormatConfig implements IModIdFormatConfig {
    protected static final List<class_124> defaultModNameFormat = List.of(class_124.field_1078, class_124.field_1056);
    public static final String MOD_NAME_FORMAT_CODE = "%MODNAME%";

    private final Supplier<String> modNameFormat;
    @Nullable
    private String cachedOverride; // when we detect another mod is adding mod names to tooltips, use its formatting

    public ModIdFormatConfig(IConfigSchemaBuilder builder) {
        IConfigCategoryBuilder modName = builder.addCategory("modname");
        Supplier<List<class_124>> configValue = modName.addList(
            "ModNameFormat",
            defaultModNameFormat,
            ChatFormattingSerializer.INSTANCE,
            "Formatting for mod name tooltip"
        );
        this.modNameFormat = new CachedSupplierTransformer<>(configValue, ModIdFormatConfig::toFormatString);
    }

    private static String toFormatString(List<class_124> values) {
        return values.stream()
            .map(class_124::toString)
            .collect(Collectors.joining());
    }

    private String getOverride() {
        if (cachedOverride == null) {
            cachedOverride = detectModNameTooltipFormatting();
        }
        return cachedOverride;
    }

    @Override
    public final String getModNameFormat() {
        String override = getOverride();
        if (!override.isEmpty()) {
            return override;
        }
        return modNameFormat.get();
    }

    @Override
    public final boolean isModNameFormatOverrideActive() {
        return !getOverride().isEmpty();
    }

    private String detectModNameTooltipFormatting() {
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        List<class_2561> tooltip = itemStackHelper.getTestTooltip(player, new class_1799(class_1802.field_8279));
        if (tooltip.size() <= 1) {
            return "";
        }

        for (int lineNum = 1; lineNum < tooltip.size(); lineNum++) {
            class_2561 line = tooltip.get(lineNum);
            String lineString = line.getString();
            if (lineString.contains(ModIds.MINECRAFT_NAME)) {
                String withoutFormatting = class_124.method_539(lineString);
                if (withoutFormatting != null && withoutFormatting.contains(ModIds.MINECRAFT_NAME)) {
                    return StringUtils.replaceOnce(lineString, ModIds.MINECRAFT_NAME, MOD_NAME_FORMAT_CODE);
                }
            }
        }
        return "";
    }
}
