/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.transfer;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.ingredients.RecipeSlots;
import mezz.jei.common.gui.recipes.layout.IRecipeLayoutInternal;
import mezz.jei.common.recipes.RecipeTransferManager;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.TransferOperation;
import mezz.jei.common.util.ItemStackMatchable;
import mezz.jei.common.util.MatchingIterable;
import mezz.jei.common.util.StringUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class RecipeTransferUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private RecipeTransferUtil() {
    }

    @Nullable
    public static IRecipeTransferError getTransferRecipeError(RecipeTransferManager recipeTransferManager, class_1703 container, IRecipeLayoutInternal<?> recipeLayout, class_1657 player) {
        return RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, false, false);
    }

    public static boolean transferRecipe(RecipeTransferManager recipeTransferManager, class_1703 container, IRecipeLayoutInternal<?> recipeLayout, class_1657 player, boolean maxTransfer) {
        IRecipeTransferError error = RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, maxTransfer, true);
        return RecipeTransferUtil.allowsTransfer(error);
    }

    @Nullable
    private static <C extends class_1703, R> IRecipeTransferError transferRecipe(RecipeTransferManager recipeTransferManager, C container, IRecipeLayoutInternal<R> recipeLayout, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        if (Internal.getRuntime().isEmpty()) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
        IRecipeTransferHandler<C, R> transferHandler = recipeTransferManager.getRecipeTransferHandler(container, recipeCategory);
        if (transferHandler == null) {
            if (doTransfer) {
                LOGGER.error("No Recipe Transfer handler for container {}", container.getClass());
            }
            return RecipeTransferErrorInternal.INSTANCE;
        }
        RecipeSlots recipeSlots = recipeLayout.getRecipeSlots();
        IRecipeSlotsView recipeSlotsView = recipeSlots.getView();
        try {
            return transferHandler.transferRecipe(container, recipeLayout.getRecipe(), recipeSlotsView, player, maxTransfer, doTransfer);
        }
        catch (RuntimeException e) {
            LOGGER.error("Recipe transfer handler '{}' for container '{}' and recipe type '{}' threw an error: ", transferHandler.getClass(), transferHandler.getContainerClass(), (Object)recipeCategory.getRecipeType().getUid(), (Object)e);
            return RecipeTransferErrorInternal.INSTANCE;
        }
    }

    public static boolean allowsTransfer(@Nullable IRecipeTransferError error) {
        return error == null || error.getType() == IRecipeTransferError.Type.COSMETIC;
    }

    public static boolean validateSlots(class_1657 player, Collection<TransferOperation> transferOperations, Collection<class_1735> craftingSlots, Collection<class_1735> inventorySlots) {
        Set<Integer> inventorySlotIndexes = inventorySlots.stream().map(s -> s.field_7874).collect(Collectors.toSet());
        Set<Integer> craftingSlotIndexes = craftingSlots.stream().map(s -> s.field_7874).collect(Collectors.toSet());
        List<Integer> invalidRecipeIndexes = transferOperations.stream().map(TransferOperation::craftingSlot).map(s -> s.field_7874).filter(s -> !craftingSlotIndexes.contains(s)).toList();
        if (!invalidRecipeIndexes.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots for the destination of the recipe, the slots are not included in the list of crafting slots. " + StringUtil.intsToString(invalidRecipeIndexes));
            return false;
        }
        List<Integer> invalidInventorySlotIndexes = transferOperations.stream().map(TransferOperation::inventorySlot).map(s -> s.field_7874).filter(s -> !inventorySlotIndexes.contains(s) && !craftingSlotIndexes.contains(s)).toList();
        if (!invalidInventorySlotIndexes.isEmpty()) {
            LOGGER.error("Transfer handler has invalid source slots for the inventory stacks for the recipe, the slots are not included in the list of inventory slots or recipe slots. " + StringUtil.intsToString(invalidInventorySlotIndexes) + "\n inventory slots: " + StringUtil.intsToString(inventorySlotIndexes) + "\n crafting slots: " + StringUtil.intsToString(craftingSlotIndexes));
            return false;
        }
        Set<Integer> overlappingSlots = inventorySlotIndexes.stream().filter(craftingSlotIndexes::contains).collect(Collectors.toSet());
        if (!overlappingSlots.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots, inventorySlots and craftingSlots should not share any slot, but both have: " + StringUtil.intsToString(overlappingSlots));
            return false;
        }
        List<Integer> invalidPickupSlots = Stream.concat(craftingSlots.stream(), inventorySlots.stream()).filter(class_1735::method_7681).filter(slot -> !slot.method_7674(player)).map(slot -> slot.field_7874).toList();
        if (!invalidPickupSlots.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots, the player is unable to pickup from them: " + StringUtil.intsToString(invalidPickupSlots));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static RecipeTransferOperationsResult getRecipeTransferOperations(final IStackHelper stackhelper, Map<class_1735, class_1799> availableItemStacks, List<IRecipeSlotView> requiredItemStacks, List<class_1735> craftingSlots) {
        void var7_11;
        RecipeTransferOperationsResult transferOperations = new RecipeTransferOperationsResult();
        IdentityHashMap<IRecipeSlotView, Map> relevantSlots = new IdentityHashMap<IRecipeSlotView, Map>();
        for (Map.Entry<class_1735, class_1799> entry : availableItemStacks.entrySet()) {
            for (IRecipeSlotView ingredient : requiredItemStacks) {
                if (ingredient.isEmpty() || !ingredient.getItemStacks().anyMatch(it -> stackhelper.isEquivalent((class_1799)it, (class_1799)slotTuple.getValue(), UidContext.Ingredient))) continue;
                relevantSlots.computeIfAbsent(ingredient, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<class_1799>(){

                    public int hashCode(class_1799 o) {
                        return o.method_7909().hashCode();
                    }

                    public boolean equals(class_1799 a, class_1799 b) {
                        return stackhelper.isEquivalent(a, b, UidContext.Ingredient);
                    }
                })).computeIfAbsent(entry.getValue(), it -> new ArrayList()).add(new PhantomSlotState(entry.getKey(), entry.getValue()));
            }
        }
        Object2ObjectArrayMap bestMatches = new Object2ObjectArrayMap();
        for (Map.Entry entry : relevantSlots.entrySet()) {
            ArrayList<PhantomSlotStateList> countedAndSorted = new ArrayList<PhantomSlotStateList>();
            for (Map.Entry foundSlots : ((Map)entry.getValue()).entrySet()) {
                ((ArrayList)foundSlots.getValue()).sort((o1, o2) -> {
                    int compare = Integer.compare(o1.itemStack.method_7947(), o2.itemStack.method_7947());
                    if (compare == 0) {
                        return Integer.compare(o1.slot.field_7874, o2.slot.field_7874);
                    }
                    return compare;
                });
                countedAndSorted.add(new PhantomSlotStateList((List)foundSlots.getValue()));
            }
            countedAndSorted.sort((o1, o2) -> {
                int compare = Long.compare(o2.totalItemCount, o1.totalItemCount);
                if (compare == 0) {
                    return Integer.compare(o1.stateList.stream().mapToInt(it -> it.slot.field_7874).min().orElse(0), o2.stateList.stream().mapToInt(it -> it.slot.field_7874).min().orElse(0));
                }
                return compare;
            });
            bestMatches.put((IRecipeSlotView)entry.getKey(), countedAndSorted);
        }
        for (IRecipeSlotView iRecipeSlotView : requiredItemStacks) {
            if (iRecipeSlotView.isEmpty()) continue;
            bestMatches.computeIfAbsent(iRecipeSlotView, it -> new ArrayList());
        }
        boolean bl = false;
        while (var7_11 < requiredItemStacks.size()) {
            IRecipeSlotView iRecipeSlotView = requiredItemStacks.get((int)var7_11);
            if (!iRecipeSlotView.isEmpty()) {
                class_1735 craftingSlot = craftingSlots.get((int)var7_11);
                PhantomSlotState matching = ((ArrayList)bestMatches.get(iRecipeSlotView)).stream().flatMap(PhantomSlotStateList::stream).findFirst().orElse(null);
                if (matching == null) {
                    transferOperations.missingItems.add(iRecipeSlotView);
                } else {
                    class_1735 matchingSlot = matching.slot;
                    class_1799 matchingStack = matching.itemStack;
                    matchingStack.method_7934(1);
                    transferOperations.results.add(new TransferOperation(matchingSlot, craftingSlot));
                }
            }
            ++var7_11;
        }
        return transferOperations;
    }

    @Nullable
    public static <T> Map.Entry<T, class_1799> containsAnyStackIndexed(IStackHelper stackhelper, Map<T, class_1799> stacks, IRecipeSlotView recipeSlotView) {
        MatchingIndexed<T> matchingStacks = new MatchingIndexed<T>(stacks);
        List<class_1799> ingredients = recipeSlotView.getItemStacks().toList();
        MatchingIterable matchingContains = new MatchingIterable(ingredients);
        return (Map.Entry)RecipeTransferUtil.containsStackMatchable(stackhelper, matchingStacks, matchingContains);
    }

    @Nullable
    public static <R, T> R containsStackMatchable(IStackHelper stackhelper, Iterable<ItemStackMatchable<R>> stacks, Iterable<ItemStackMatchable<T>> contains) {
        for (ItemStackMatchable<T> containStack : contains) {
            R matchingStack = RecipeTransferUtil.containsStack(stackhelper, stacks, containStack);
            if (matchingStack == null) continue;
            return matchingStack;
        }
        return null;
    }

    @Nullable
    public static <R> R containsStack(IStackHelper stackHelper, Iterable<ItemStackMatchable<R>> stacks, ItemStackMatchable<?> contains) {
        for (ItemStackMatchable<R> stack : stacks) {
            if (!stackHelper.isEquivalent(contains.getStack(), stack.getStack(), UidContext.Recipe)) continue;
            return stack.getResult();
        }
        return null;
    }

    private record PhantomSlotState(class_1735 slot, class_1799 itemStack) {
    }

    private record PhantomSlotStateList(List<PhantomSlotState> stateList, long totalItemCount) {
        public PhantomSlotStateList(List<PhantomSlotState> states) {
            this(states, states.stream().mapToLong(it -> it.itemStack.method_7947()).sum());
        }

        public Stream<PhantomSlotState> stream() {
            return this.stateList.stream().filter(it -> !it.itemStack.method_7960());
        }
    }

    private static class MatchingIndexed<T>
    implements Iterable<ItemStackMatchable<Map.Entry<T, class_1799>>> {
        private final Map<T, class_1799> map;

        public MatchingIndexed(Map<T, class_1799> map) {
            this.map = map;
        }

        @Override
        public Iterator<ItemStackMatchable<Map.Entry<T, class_1799>>> iterator() {
            return new MatchingIterable.DelegateIterator<Map.Entry<T, class_1799>, ItemStackMatchable<Map.Entry<T, class_1799>>>(this.map.entrySet().iterator()){

                @Override
                public ItemStackMatchable<Map.Entry<T, class_1799>> next() {
                    final Map.Entry entry = (Map.Entry)this.delegate.next();
                    return new ItemStackMatchable<Map.Entry<T, class_1799>>(){

                        @Override
                        public class_1799 getStack() {
                            return (class_1799)entry.getValue();
                        }

                        @Override
                        public Map.Entry<T, class_1799> getResult() {
                            return entry;
                        }
                    };
                }
            };
        }
    }
}

