/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input.handlers;

import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.config.IEditModeConfig;
import mezz.jei.common.ingredients.IngredientFilter;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.input.CombinedRecipeFocusSource;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.input.handlers.LimitedAreaInputHandler;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.core.config.IngredientBlacklistType;
import net.minecraft.class_437;

public class EditInputHandler
implements IUserInputHandler {
    private final CombinedRecipeFocusSource focusSource;
    private final RegisteredIngredients registeredIngredients;
    private final IngredientFilter ingredientFilter;
    private final IWorldConfig worldConfig;
    private final IEditModeConfig editModeConfig;

    public EditInputHandler(CombinedRecipeFocusSource focusSource, RegisteredIngredients registeredIngredients, IngredientFilter ingredientFilter, IWorldConfig worldConfig, IEditModeConfig editModeConfig) {
        this.focusSource = focusSource;
        this.registeredIngredients = registeredIngredients;
        this.ingredientFilter = ingredientFilter;
        this.worldConfig = worldConfig;
        this.editModeConfig = editModeConfig;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (!this.worldConfig.isEditModeEnabled()) {
            return Optional.empty();
        }
        if (input.is(keyBindings.getToggleHideIngredient())) {
            return this.handle(input, keyBindings, IngredientBlacklistType.ITEM);
        }
        if (input.is(keyBindings.getToggleWildcardHideIngredient())) {
            return this.handle(input, keyBindings, IngredientBlacklistType.WILDCARD);
        }
        return Optional.empty();
    }

    private Optional<IUserInputHandler> handle(UserInput input, IInternalKeyMappings keyBindings, IngredientBlacklistType blacklistType) {
        return this.focusSource.getIngredientUnderMouse(input, keyBindings).findFirst().map(clicked -> {
            if (!input.isSimulate()) {
                this.execute((IClickedIngredient)clicked, blacklistType);
            }
            return LimitedAreaInputHandler.create(this, clicked.getArea());
        });
    }

    private <V> void execute(IClickedIngredient<V> clicked, IngredientBlacklistType blacklistType) {
        IIngredientHelper<V> ingredientHelper;
        ITypedIngredient<V> typedIngredient = clicked.getTypedIngredient();
        if (this.editModeConfig.isIngredientOnConfigBlacklist(typedIngredient, ingredientHelper = this.registeredIngredients.getIngredientHelper(typedIngredient.getType()))) {
            this.editModeConfig.removeIngredientFromConfigBlacklist(this.ingredientFilter, typedIngredient, blacklistType, ingredientHelper);
        } else {
            this.editModeConfig.addIngredientToConfigBlacklist(this.ingredientFilter, typedIngredient, blacklistType, ingredientHelper);
        }
    }
}

