/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input.handlers;

import java.util.List;
import java.util.Optional;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.InputType;
import mezz.jei.common.input.UserInput;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class CombinedInputHandler
implements IUserInputHandler {
    private final List<IUserInputHandler> inputHandlers;

    public CombinedInputHandler(IUserInputHandler ... inputHandlers) {
        this.inputHandlers = List.of(inputHandlers);
    }

    public CombinedInputHandler(List<IUserInputHandler> inputHandlers) {
        this.inputHandlers = List.copyOf(inputHandlers);
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
        return switch (input.getClickState()) {
            default -> throw new IncompatibleClassChangeError();
            case InputType.IMMEDIATE, InputType.SIMULATE -> this.handleClickInternal(screen, input, keyBindings);
            case InputType.EXECUTE -> Optional.empty();
        };
    }

    private Optional<IUserInputHandler> handleClickInternal(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
        Optional<IUserInputHandler> firstHandled = Optional.empty();
        for (IUserInputHandler inputHandler : this.inputHandlers) {
            if (firstHandled.isEmpty()) {
                firstHandled = inputHandler.handleUserInput(screen, input, keyBindings);
                if (!firstHandled.isEmpty()) continue;
                inputHandler.handleMouseClickedOut(input.getKey());
                continue;
            }
            inputHandler.handleMouseClickedOut(input.getKey());
        }
        return firstHandled;
    }

    @Override
    public void handleMouseClickedOut(class_3675.class_306 key) {
        for (IUserInputHandler inputHandler : this.inputHandlers) {
            inputHandler.handleMouseClickedOut(key);
        }
    }

    @Override
    public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        return this.inputHandlers.stream().flatMap(inputHandler -> inputHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta).stream()).findFirst();
    }
}

