/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.overlay.bookmarks;

import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.common.bookmarks.BookmarkList;
import mezz.jei.common.gui.elements.GuiIconToggleButton;
import mezz.jei.common.gui.overlay.bookmarks.BookmarkOverlay;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.UserInput;
import mezz.jei.core.config.IWorldConfig;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class BookmarkButton
extends GuiIconToggleButton {
    private final BookmarkOverlay bookmarkOverlay;
    private final BookmarkList bookmarkList;
    private final IWorldConfig worldConfig;
    private final IInternalKeyMappings keyBindings;

    public static BookmarkButton create(BookmarkOverlay bookmarkOverlay, BookmarkList bookmarkList, Textures textures, IWorldConfig worldConfig, IInternalKeyMappings keyBindings) {
        IDrawableStatic offIcon = textures.getBookmarkButtonDisabledIcon();
        IDrawableStatic onIcon = textures.getBookmarkButtonEnabledIcon();
        return new BookmarkButton(offIcon, onIcon, textures, bookmarkOverlay, bookmarkList, worldConfig, keyBindings);
    }

    private BookmarkButton(IDrawable offIcon, IDrawable onIcon, Textures textures, BookmarkOverlay bookmarkOverlay, BookmarkList bookmarkList, IWorldConfig worldConfig, IInternalKeyMappings keyBindings) {
        super(offIcon, onIcon, textures);
        this.bookmarkOverlay = bookmarkOverlay;
        this.bookmarkList = bookmarkList;
        this.worldConfig = worldConfig;
        this.keyBindings = keyBindings;
    }

    @Override
    protected void getTooltips(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43471((String)"jei.tooltip.bookmarks"));
        IJeiKeyMapping bookmarkKey = this.keyBindings.getBookmark();
        if (bookmarkKey.isUnbound()) {
            class_5250 noKey = class_2561.method_43471((String)"jei.tooltip.bookmarks.usage.nokey");
            tooltip.add((class_2561)noKey.method_27692(class_124.field_1061));
        } else if (!this.bookmarkOverlay.hasRoom()) {
            class_5250 notEnoughSpace = class_2561.method_43471((String)"jei.tooltip.bookmarks.not.enough.space");
            tooltip.add((class_2561)notEnoughSpace.method_27692(class_124.field_1065));
        } else {
            class_5250 key = class_2561.method_43469((String)"jei.tooltip.bookmarks.usage.key", (Object[])new Object[]{bookmarkKey.getTranslatedKeyMessage()});
            tooltip.add((class_2561)key.method_27692(class_124.field_1080));
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.bookmarkOverlay.isListDisplayed();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (!this.bookmarkList.isEmpty() && this.bookmarkOverlay.hasRoom()) {
            if (!input.isSimulate()) {
                this.worldConfig.toggleBookmarkEnabled();
            }
            return true;
        }
        return false;
    }
}

